package com.ulcjava.base.application.datatype;


	/**
	* The <code>ULCDateDataType</code> formats the displayed date (java.util.Date)
	* and validates user input to be a valid
	* date.
<p>
</p>
<b>Features</b>
<ul>
<li>A format string can be supplied to
	* define the format to be used. The format string must represent a pattern as
	* defined by the
<code>java.util.DateFormat</code> class.
<li>A date
	* representing the beginning of the 100-year period assumed in 2-digit years
	* canbe specified. For instance, if this start date
is set to Jan 1, 1950, then
	* date string "1.1.40" will be interpreted as Jan 1, 2040, whereas the date
	* string "1.1.60" will be interpreted
as January 1,
	* 1960.
</ul>
<b>Examples</b>
<p>
</p>
The following example shows how a
	* <code>ULCLabel</code> can be used to visualize a <code>java.util.Date</code>
	* object.

<pre>
ULCLabel dateLabel = new ULCLabel();
dateLabel.setDataType(new
	* ULCDateDataType(&quot;yyyyy.MMMMM.dd GGG&quot;));
dateLabel.setValue(new
	* Date());
</pre>
	*
	* @ulc.application		
	**/
 public class ULCDateDataType extends com.ulcjava.base.application.datatype.ULCAbstractDataType implements com.ulcjava.base.application.datatype.IDataType
{


	/**
	* Constructs a new date data type.
	*
	**/
	 public ULCDateDataType()
	{
		 super();
	}


	/**
	* Constructs a new date data type.
	*
	* @param errorManager 		 that coordinates client and server side error handling
	**/
	 public ULCDateDataType(com.ulcjava.base.application.datatype.ULCAbstractErrorManager errorManager)
	{
		 super();
	}


	/**
	* Constructs a new date data type with the specified date format. The
	* formatString specified must be a valid format for the
	* Java
<code>SimpleDateFormat</code> class.
	*
	* @param formatString 		 a valid format for the Java <code>SimpleDateFormat</code> class
	**/
	 public ULCDateDataType(java.lang.String formatString)
	{
		 super();
	}


	/**
	* Constructs a new date data type with the specified date format. The
	* formatString specified must be a valid format for the
	* Java
<code>SimpleDateFormat</code> class.
	*
	* @param errorManager 		 that coordinates client and server side error handling
	* @param formatString 		 a valid format for the Java <code>SimpleDateFormat</code> class
	**/
	 public ULCDateDataType(com.ulcjava.base.application.datatype.ULCAbstractErrorManager errorManager, java.lang.String formatString)
	{
		 super();
	}

	 protected java.lang.String typeString()
	{
		return null;
	}

	 protected void uploadStateUI()
	{
	}


	/**
	* Return the format string of this date validator. Format strings can contain
	* multiple formats to allow partial input of dates as well:
The multiple
	* formatsare separated by the '|' character. eg: 'dd.MM.yy|dd.MM|dd' would
	* allowthe user to enter either the full
dd.mm.yy format or the dd.MM format or
	* just dd. Month and year of incomplete date entries are complemented with the
	* current month and
year.
<p>
</p>
Format strings can contain multiple formats
	* to allow partial input of dates as well: The multiple formats are separated
	* bythe '|'
character. eg: 'dd.MM.yy|dd.MM|dd' would allow the user to enter
	* either the full dd.mm.yy format or the dd.MM format or just dd.
Month and
	* yearof incomplete date entries are complemented with the current month and
	* year.
	*
	* @return		the format string for this date validator.
	**/
	 public java.lang.String getFormatString()
	{
		return null;
	}


	/**
	* Sets the format string of this date validator. The formatString specified must
	* be a valid format for the Java
<code>SimpleDateFormat</code> class. Dates are
	* exchanged between the UI and the ULC in the GMT timezone. Format strings can
	* contain
multiple formats to allow partial input of dates as well: The
	* multipleformats are separated by the '|' character. eg:
'dd.MM.yy|dd.MM|dd'
	* would allow the user to enter either the full dd.mm.yy format or the dd.MM
	* format or just dd. Month and year of
incomplete date entries are complemented
	* with the current month and year.
	*
	* @param formatString 		 a valid format string for the Java <code>SimpleDateFormat</code> class
	**/
	 public void setFormatString(java.lang.String formatString)
	{
	}


	/**
	* Returns the beginning of the 100-year period 2-digit years are interpreted as
	* being within.
	*
	* @return		the beginning of the 100-year period into which 2-digit years are placed
	**/
	 public java.util.Date getTwoDigitYearStart()
	{
		return null;
	}


	/**
	* Sets the beginning of the 100-year period assumed for 2-digit years.
	*
	* @param twoDigitYearStart 		 2-digit years will be placed in the range <code>twoDigitYearStart</code> to
<code>twoDigitYearStart + 100</code> years.
	**/
	 public void setTwoDigitYearStart(java.util.Date twoDigitYearStart)
	{
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCDateDataTypeDispatcher extends ULCAbstractDataTypeDispatcher
{


}
}