package com.ulcjava.base.application.datatype;


	/**
	* The <code>ULCPercentDataType</code> formats numbers as percentage
	* values.
<p>
</p>
<b>Features</b>
<ul>
<li><code>ULCPercentDataType</code>
	* validates user input to be valid double
	* numbers.
<li><code>ULCPercentDataType</code> respects the <code>Locale</code>
	* and hence supports internationalization.
<li>If the validation fails and the
	* <code>ULCPercentDataType</code> has an <code>ULCAbstractErrorManager</code>
	* set, an<code>ErrorObject</code>
with the error code
	* <code>ErrorCodes.ERROR_CODE_BAD_DOUBLE_FORMAT</code> and the invalid input is
	* put on the error manager.
</ul>
<b>Examples</b>
<p>
</p>
The following
	* exampleuses a <code>ULCTextField</code> with a
	* <code>ULCPercentDataType</code>to edit percentage value.

<pre>
ULCTextField
	* percentField = new ULCTextField();
ULCPercentDataType percentValidator = new
	* ULCPercentDataType(new Locale("de",
	* "DE"));
percentValidator.setFractionalDigits(3);
percentField.setDataType(perce
	* ntValidator);
</pre>
	*
	* @ulc.application		
	**/
 public class ULCPercentDataType extends com.ulcjava.base.application.datatype.ULCAbstractDataType
{

	/**
	* Round away from zero. Always increments the digit prior to a non-zero
	* discardedfraction. Note that this rounding mode never
decreases the magnitude
	* of the calculated value.
	*
	**/
	 public  final  static int ROUND_UP = 0;

	/**
	* Round towards zero. Never increments the digit prior to a discarded fraction
	* (i.e., truncates). Note that this rounding mode never
increases the magnitude
	* of the calculated value.
	*
	**/
	 public  final  static int ROUND_DOWN = 0;

	/**
	* Round towards positive infinity. If the BigDecimal is positive, behaves as for
	* <tt>ROUND_UP</tt>; if negative, behaves as for
<tt>ROUND_DOWN</tt>. Note that
	* this rounding mode never decreases the calculated value.
	*
	**/
	 public  final  static int ROUND_CEILING = 0;

	/**
	* RRound towards negative infinity. If the BigDecimal is positive, behave as for
	* <tt>ROUND_DOWN</tt>; if negative, behave as for
<tt>ROUND_UP</tt>. Note that
	* this rounding mode never increases the calculated value.
	*
	**/
	 public  final  static int ROUND_FLOOR = 0;

	/**
	* Round towards "nearest neighbor" unless both neighbors are equidistant, in
	* which case round up. Behaves as for <tt>ROUND_UP</tt> if
the discarded
	* fraction is &gt;= .5; otherwise, behaves as for <tt>ROUND_DOWN</tt>. Note
	* thatthis is the rounding mode that most
of us were taught in grade school.
	*
	**/
	 public  final  static int ROUND_HALF_UP = 0;

	/**
	* Round towards "nearest neighbor" unless both neighbors are equidistant, in
	* which case round down. Behaves as for <tt>ROUND_UP</tt>
if the discarded
	* fraction is &gt; .5; otherwise, behaves as for <tt>ROUND_DOWN</tt>.
	*
	**/
	 public  final  static int ROUND_HALF_DOWN = 0;

	/**
	* Round towards the "nearest neighbor" unless both neighbors are equidistant, in
	* which case, round towards the even neighbor. Behaves
as for ROUND_HALF_UP if
	* the digit to the left of the discarded fraction is odd; behaves as for
	* ROUND_HALF_DOWN if it's even. Note
that this is the rounding mode that
	* minimizes cumulative error when applied repeatedly over a sequence of
	* calculations.
	*
	**/
	 public  final  static int ROUND_HALF_EVEN = 0;

	/**
	* Rounding mode to assert that the requested operation has an exact result,
	* henceno rounding is necessary. If this rounding mode is
specified on an
	* operation that yields an inexact result, an <tt>ArithmeticException</tt> is
	* thrown.
	*
	**/
	 public  final  static int ROUND_UNNECESSARY = 0;


	/**
	* Constructs a new percent data type with the locale from
	* <code>ClientContext</code> and 2 fractional digits and no error manager.
	*
	**/
	 public ULCPercentDataType()
	{
		 super();
	}


	/**
	* Constructs a new percent data type with the locale from
	* <code>ClientContext</code> and 2 fractional digits and the given error
manager.
	*
	**/
	 public ULCPercentDataType(com.ulcjava.base.application.datatype.ULCAbstractErrorManager errorManager)
	{
		 super();
	}


	/**
	* Constructs a new percent data type with the locale from
	* <code>ClientContext</code> and the specified number of fractional digits
and
	* no error manager.
	*
	* @param fractDigits 		 The number of fractional digits allowed.
	**/
	 public ULCPercentDataType(int fractDigits)
	{
		 super();
	}


	/**
	* Constructs a new percent data type with the locale from
	* <code>ClientContext</code> and the specified number of fractional digits
and
	* the given error manager.
	*
	* @param errorManager 		 that coordinates client and server side error handling
	* @param fractDigits 		 The number of fractional digits allowed.
	**/
	 public ULCPercentDataType(com.ulcjava.base.application.datatype.ULCAbstractErrorManager errorManager, int fractDigits)
	{
		 super();
	}


	/**
	* Constructs a new number data type using the given locale and 2 fractional
	* digits and no error manager.
	*
	* @param locale 		 the locale to use for formatting
	**/
	 public ULCPercentDataType(java.util.Locale locale)
	{
		 super();
	}


	/**
	* Constructs a new number data type using the given locale and 2 fractional
	* digits and the given error manager.
	*
	* @param errorManager 		 that coordinates client and server side error handling
	* @param locale 		 the locale to use for formatting
	**/
	 public ULCPercentDataType(com.ulcjava.base.application.datatype.ULCAbstractErrorManager errorManager, java.util.Locale locale)
	{
		 super();
	}


	/**
	* Constructs a new number data type using the given locale and no error manager.
	*
	* @param locale 		 the locale to use for formatting
	* @param fractionalDigits 		 The number of fractional digits allowed.
	**/
	 public ULCPercentDataType(java.util.Locale locale, int fractionalDigits)
	{
		 super();
	}


	/**
	* Constructs a new number data type using the given locale and the given error
	* manager.
	*
	* @param errorManager 		 that coordinates client and server side error handling
	* @param locale 		 the locale to use for formatting
	* @param fractionalDigits 		 The number of fractional digits allowed.
	**/
	 public ULCPercentDataType(com.ulcjava.base.application.datatype.ULCAbstractErrorManager errorManager, java.util.Locale locale, int fractionalDigits)
	{
		 super();
	}


	/**
	* Returns the fractional Digits property.
	*
	* @return		int the fractional Digits property
	**/
	 public int getFractionalDigits()
	{
		return 0;
	}

	 protected java.lang.String typeString()
	{
		return null;
	}

	 protected void uploadStateUI()
	{
	}


	/**
	* Sets the fractional Digits property.
<p>
</p>
<b>Note:</b> Setting this value
	* after the widget has been uploaded has no effect.
	*
	* @param newFracDigits 		 the number of fractional digits
	**/
	 public void setFractionalDigits(int newFracDigits)
	{
	}


	/**
	* Gets the rounding mode.
	*
	* @return		the rounding mode.
	* @see		#setRoundingMode(int)
	**/
	 public int getRoundingMode()
	{
		return 0;
	}


	/**
	* Sets the rounding mode. The default is ROUND_HALF_EVEN. The valid modes
	* are:
<ul>
<li> ROUND_UP
<li> ROUND_DOWN
<li> ROUND_CEILING
<li>
	* ROUND_FLOOR
<li> ROUND_HALF_UP
<li> ROUND_HALF_DOWN
<li> ROUND_HALF_EVEN
<li>
	* ROUND_UNNECESSARY
</ul>
<p>
</p>
<b>Note:</b> Setting this value after the
	* widget has been uploaded has no effect.
	*
	* @param roundingMode 		 the rounding mode.
	* @throws		IllegalArgumentException <tt>roundingMode</tt> does not represent a valid rounding modes.
	* @see		#ROUND_UP
	* @see		#ROUND_DOWN
	* @see		#ROUND_CEILING
	* @see		#ROUND_FLOOR
	* @see		#ROUND_HALF_UP
	* @see		#ROUND_HALF_DOWN
	* @see		#ROUND_HALF_EVEN
	* @see		#ROUND_UNNECESSARY
	**/
	 public void setRoundingMode(int roundingMode)
	{
	}


	/**
	* Returns true if grouping is being used, false otherwise.
	*
	* @return		true if grouping is being used, false otherwise
	**/
	 public boolean isGroupingUsed()
	{
		return false;
	}


	/**
	* Sets whether or not grouping should be used.
<p>
</p>
<b>Note:</b> Setting
	* thisvalue after the widget has been uploaded has no effect.
	*
	* @param useGroups 		 flag to indicate whether or not grouping should be used
	**/
	 public void setGroupingUsed(boolean useGroups)
	{
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCPercentDataTypeDispatcher extends ULCAbstractDataTypeDispatcher
{


}
}