package com.ulcjava.base.application.datatype;


	/**
	* The <code>ULCRegularExpressionDataType</code> ensures that the input adheres
	* tothe pattern defined by a given regular expression.
<p>
</p>
By default,
	* thisclass uses the JDK regular expression support
	* (<code>java.util.regex</code>). A custom adapter class
	* implementing
<code>IRegularExpressionMatcher</code> can be installed on the
	* client side in the launcher by invoking
	* the
<code>UIRegularExpressionDataType.setRegularExpressionMatcher()</code>
	* method. Any non-JDK libraries the custom adapter class relies on
must be
	* deployed onto the client machine.
<p>
</p>
<b>Features</b>
<ul>
<li>The
	* <code>ULCRegularExpressionDataType</code> can be configured with two regular
	* expressions:
<ul>
<li>The first expression is used to validate the user input
	* before it is sent to the application side (e.g., field loses the
	* focus).
<li>The second expression is used to validate the user entry after
	* each keystroke (e.g., keystroke or paste from the
	* clipboard).
</ul>
</ul>
<b>Examples</b>
<p>
</p>
The following example shows
	* a<code>ULCTextField</code> that only accepts ID numbers in a specific format.
	* The number is checked to
contain only digits and "-" characters after each
	* keystroke, and is checked to adhere to the defined format before being sent
	* tothe
application side.

<pre>
ULCTextField idNumberField = new
	* ULCTextField();
ULCRegularExpressionDataType idValidator = new
	* ULCRegularExpressionDataType(
&quot;[0-9]{3}-[0-9]{5}-[0-9]{2}&quot;, //
	* checked before sent to app
&quot;[0-9|-]+&quot; // checked after each
	* keystroke
);
idNumberField.setDataType(idValidator);
</pre>
	*
	* @ulc.application		
	**/
 public class ULCRegularExpressionDataType extends com.ulcjava.base.application.datatype.ULCAbstractDataType implements com.ulcjava.base.application.datatype.IDataType
{


	/**
	* Constructs a new regular expression data type.
	*
	**/
	 public ULCRegularExpressionDataType()
	{
		 super();
	}


	/**
	* Constructs a new regular expression data type with the specified
	* validateExpression.
	*
	* @param validateExpression 		 the expression that will be validated before the input is returned to the application.
	**/
	 public ULCRegularExpressionDataType(java.lang.String validateExpression)
	{
		 super();
	}


	/**
	* Constructs a new regular expression data type.
	*
	* @param errorManager 		 that coordinates client and server side error handling
	**/
	 public ULCRegularExpressionDataType(com.ulcjava.base.application.datatype.ULCAbstractErrorManager errorManager)
	{
		 super();
	}


	/**
	* Constructs a new regular expression data type with the specified
	* validateExpression.
	*
	* @param errorManager 		 that coordinates client and server side error handling
	* @param validateExpression 		 the expression that will be validated before the input is returned to the application.
	**/
	 public ULCRegularExpressionDataType(com.ulcjava.base.application.datatype.ULCAbstractErrorManager errorManager, java.lang.String validateExpression)
	{
		 super();
	}


	/**
	* Constructs a new regular expression data type with both input and validate
	* expressions. In most cases the
<code>inputFilterExpression</code> is less
	* strict compared to the <code>validateExpression</code>.
	*
	* @param validateExpression 		 the expression that will be validated before the input is returned to the application.
	* @param inputFilterExpression 		 the expression that will be validated on each keystroke.
	**/
	 public ULCRegularExpressionDataType(java.lang.String validateExpression, java.lang.String inputFilterExpression)
	{
		 super();
	}


	/**
	* Constructs a new regular expression data type with both input and validate
	* expressions. In most cases the
<code>inputFilterExpression</code> is less
	* strict compared to the <code>validateExpression</code>.
	*
	* @param errorManager 		 that coordinates client and server side error handling
	* @param validateExpression 		 the expression that will be validated before the input is returned to the application.
	* @param inputFilterExpression 		 the expression that will be validated on each keystroke.
	* @param valueDoesNotMatchErrorCode 		 the error code that signals that the value does not match
	**/
	 public ULCRegularExpressionDataType(com.ulcjava.base.application.datatype.ULCAbstractErrorManager errorManager, java.lang.String validateExpression, java.lang.String inputFilterExpression, java.lang.String valueDoesNotMatchErrorCode)
	{
		 super();
	}


	/**
	* Returns the input filter expression.
	*
	* @return		the expression that will be validated on each keystroke
	**/
	 public java.lang.String getInputFilterExpression()
	{
		return null;
	}


	/**
	* Returns the validateExpression property.
	*
	* @return		the expression that will be validated before the input is returned to the application
	**/
	 public java.lang.String getValidateExpression()
	{
		return null;
	}

	 protected java.lang.String typeString()
	{
		return null;
	}


	/**
	* Sets the inputFilterExpression property.
<p>
</p>
<b>Note:</b> Setting this
	* value after the widget has been uploaded has no effect.
	*
	* @param newExpression 		 a new expression to be used as a filter on a keystroke
	**/
	 public void setInputFilterExpression(java.lang.String newExpression)
	{
	}


	/**
	* Sets the validateExpression to the specified string.
	*
	* @param newExpression 		 An expression that will be validated before the input is returned to the application.
	**/
	 public void setValidateExpression(java.lang.String newExpression)
	{
	}

	 protected void uploadStateUI()
	{
	}


	/**
	* sets the error code that signals that the value does not match. Assuming the
	* users are not familiar with regular expression pattern
syntax, it is nicer to
	* set context specific error code to produce messages that are better
	* understandable , for example : <i>please
enter a valid email address like
	* your.name@company.com</i>
	*
	* @param valueDoesNotMatchErrorCode 		 the error code that signals that the value does not match
	**/
	 public void setValueDoesNotMatchErrorCode(java.lang.String valueDoesNotMatchErrorCode)
	{
	}


	/**
	* 
	*
	* @return		the error code that signals that the value does not match
	**/
	 protected java.lang.String getValueDoesNotMatchErrorCode()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCRegularExpressionDataTypeDispatcher extends ULCAbstractDataTypeDispatcher
{


}
}