package com.ulcjava.base.application.enabler;


	/**
	* The <code>ULCHasChangedEnabler</code> is used to combine multiple components
	* implementing the <code>IHasChangedSource</code> interface to
act as an
	* enabling source. The enabling state of a <code>ULCHasChangedEnabler</code>
	* changes to <code>true</code> when one of the
contained
	* <code>IHasChangedSource</code>s gets dirty. It requires an explicit
	* <code>reset()</code> call to reset the enabling state
	* to
<code>false</code>.
<p>
</p>
<b>Examples</b>
<p>
</p>
The following
	* exampleenables the Save button when any of the fields are
	* edited.

<pre>
ULCTextField nameField = new ULCTextField(10);
ULCTextField
	* descriptionField = new ULCTextField(10);

final ULCHasChangedEnabler
	* hasChangedEnabler = new
	* ULCHasChangedEnabler();
hasChangedEnabler.add(nameField);
hasChangedEnabler.add
	* (descriptionField);

ULCButton saveButton = new
	* ULCButton(&quot;Save&quot;);
saveButton.addActionListener(new
	* IActionListener() {
public void actionPerformed(ActionEvent event)
	* {
save();
hasChangedEnabler.reset();
}
});
saveButton.setEnabler(hasChangedEnab
	* ler);
</pre>
	*
	* @ulc.application		
	* @see		IHasChangedSource
	* @see		#reset()
	**/
 public class ULCHasChangedEnabler extends com.ulcjava.base.application.ULCProxy implements com.ulcjava.base.application.enabler.IEnabler
{


	/**
	* Constructs a new has changed enabler.
	*
	**/
	 public ULCHasChangedEnabler()
	{
		 super();
	}

	 protected java.lang.String typeString()
	{
		return null;
	}


	/**
	* Adds the specified has changed source to this enabler.
	*
	* @param source 		 the has changed source to be added to this enabler
	**/
	 public void add(com.ulcjava.base.application.enabler.IHasChangedSource source)
	{
	}


	/**
	* Removes the specified has changed source from this enabler.
	*
	* @param source 		 the has changed source to be removed from this enabler
	**/
	 public void remove(com.ulcjava.base.application.enabler.IHasChangedSource source)
	{
	}


	/**
	* Resets the enabling state of this enabler.
	*
	**/
	 public void reset()
	{
	}


	/**
	* Sets the enabling state of this enabler.
	*
	* @param enabling 		 the enabling state
	**/
	 public void setEnabling(boolean enabling)
	{
	}


	/**
	* Returns the current state of this enabler.
	*
	* @return		the current state of this enabler
	**/
	 public boolean isEnabling()
	{
		return false;
	}

	 protected void updateEnabling(boolean enabling)
	{
	}

	 protected void uploadStateUI()
	{
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCHasChangedEnablerDispatcher extends ULCProxyDispatcher
{

	 public  final void updateEnabling(boolean enabling)
	{
	}


}
}