package com.ulcjava.base.application.event;


	/**
	* Focus events are low-level events that indicate that a visible component
	* (e.g.,<code>ULCTextField</code>) has gained or lost the
keyboard focus. The
	* event is passed to every <code>IFocusListener</code> object which is
	* registered to receive such events using the
component's
	* <code>addFocusListener()</code> method. As focus events are typically
	* triggered frequently, usage of these events (and
their listeners,
	* respectively) can have a negative impact on the performance of a ULC
	* application. Focus events should therefore be used
with caution. As a rule,
	* these events should be delivered asynchronously whenever
	* possible.
<p>
<b>Features</b>
<ul>
<li>The <code>FocusEvent</code> class
	* represents an event that signals that a ULC component has gained or lost the
	* keyboard focus.
<li><code>IFocusListener</code> defines the corresponding
	* interface (a <code>focusGained(FocusEvent)</code> method that is called
when
	* the component gains the focus and a <code>focusLost(FocusEvent)</code> method
	* that is called when the component loses the focus).
</ul>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.ULCComponent
	* @see		UlcEvent
	**/
 public class FocusEvent extends com.ulcjava.base.application.event.UlcEvent
{


	/**
	* Constructs a FocusEvent object.
	*
	* @param source 		 the Component that originated the event
	**/
	 public FocusEvent(java.lang.Object source)
	{
		 super((java.lang.Object)null);
	}


	/**
	* Constructs a FocusEvent object.
	*
	* @param source 		 the Component that originated the event
	* @param id 		 an integer indicating the type of event
	* @deprecated		Use {@link #FocusEvent(Object)} instead.
	**/
	 public FocusEvent(java.lang.Object source, int id)
	{
		 super((java.lang.Object)null);
	}


	/**
	* 
	*
	* @deprecated		Use new-style event delivery mechanism instead.
	**/
	 public void dispatch(com.ulcjava.base.application.event.IEventListener focusListener)
	{
	}


	/**
	* Returns the event type.
	*
	* @return		the event type
	* @deprecated		Ids are no longer needed and thus, no longer supported with the new-style event delivery mechanism. This method only
returns a valid id if the event object has been constructed using {@link #FocusEvent(Object, int)}. Otherwise, this
method returns -1.
	**/
	 public int getId()
	{
		return 0;
	}


	/**
	* 
	*
	* @deprecated		Use new-style event delivery mechanism instead.
	**/
	 public int getCategory()
	{
		return 0;
	}


}