package com.ulcjava.base.application.event;


	/**
	* Hyperlink events are used to handle user interactions in
	* <code>ULCHtmlPane</code> components, i.e., when a link is activated or when
	* a
URL cannot be loaded.
<p>
<b>Features</b>
<ul>
<li>The
	* <code>HyperlinkEvent</code> class represents a hyperlink event from a
	* <code>ULCHtmlPane</code> (either an activation or an
error
	* event).
<li><code>IHyperlinkListener</code> defines the corresponding
	* interface consisting of two methods.
	* The
<code>linkActivated(HyperlinkEvent)</code> method is called when a user
	* clicks on a hyperlink, the
<code>linkError(HyperlinkEvent)</code> method is
	* called when an error occurs while loading the contents of a
	* URL.
</ul>
<b>Examples</b>
<p>
The following code shows how to use these
	* events to maintain a history of the URLs that the user chose to view. In
	* addition, we can
display an alert to inform the user when an error occurs
	* while loading an URL.

<pre>
htmlPane.addHyperlinkListener(new
	* IHyperlinkListener() {
public void linkActivated(HyperlinkEvent event)
	* {
addToHistory(event.getURL());
}

public void linkError(HyperlinkEvent
	* event){
// bring up an alert informing the user about the error
}
});
</pre>
	*
	* @ulc.application		
	* @see		UlcEvent
	* @see		com.ulcjava.base.application.ULCHtmlPane
	**/
 public class HyperlinkEvent extends com.ulcjava.base.application.event.UlcEvent
{


	/**
	* Constructs a new object representing a hypertext link event.
	*
	* @param source 		 the object responsible for the event
	* @param description 		 the description of the affected link (this may be useful if no valid URL is used)
	* @deprecated		Use {@link #HyperlinkEvent(Object, java.net.URL, String)} instead.
	**/
	 public HyperlinkEvent(java.lang.Object source, java.lang.String description)
	{
		 super((java.lang.Object)null);
	}


	/**
	* Constructs a new object representing a hypertext link event.
	*
	* @param source 		 the object responsible for the event
	* @param url 		 the affected url
	* @param description 		 the description of the affected link (this may be useful if no valid URL is used)
	**/
	 public HyperlinkEvent(java.lang.Object source, java.net.URL url, java.lang.String description)
	{
		 super((java.lang.Object)null);
	}


	/**
	* Creates a new object representing a hypertext link event.
	*
	* @param source 		 the object responsible for the event
	* @param description 		 the description of the affected link (this may be useful if no valid URL is used)
	* @param errorString 		 the error that occurred
	* @deprecated		Use {@link #HyperlinkEvent(Object, java.net.URL, String, String)} instead.
	**/
	 public HyperlinkEvent(java.lang.Object source, java.lang.String description, java.lang.String errorString)
	{
		 super((java.lang.Object)null);
	}


	/**
	* Creates a new object representing a hypertext link event.
	*
	* @param source 		 the object responsible for the event
	* @param url 		 the affected url
	* @param description 		 the description of the affected link (this may be useful if no valid URL is used)
	* @param errorString 		 the error that occurred
	**/
	 public HyperlinkEvent(java.lang.Object source, java.net.URL url, java.lang.String description, java.lang.String errorString)
	{
		 super((java.lang.Object)null);
	}


	/**
	* 
	*
	* @deprecated		Use new-style event delivery mechanism instead.
	**/
	 public void dispatch(com.ulcjava.base.application.event.IEventListener listener)
	{
	}


	/**
	* Returns the error string.
	*
	* @return		the error string
	**/
	 public java.lang.String getErrorString()
	{
		return null;
	}


	/**
	* Returns the affected URL (if a valid URL is available).
	*
	* @return		the affected URL
	**/
	 public java.net.URL getURL()
	{
		return null;
	}


	/**
	* Returns a string describing the affected link. This may be useful if no valid
	* URL is used.
	*
	* @return		a string describing the affected link
	**/
	 public java.lang.String getDescription()
	{
		return null;
	}


	/**
	* 
	*
	* @deprecated		Use new-style event delivery mechanism instead.
	**/
	 public int getCategory()
	{
		return 0;
	}


}