package com.ulcjava.base.application.event;


	/**
	* The listener interface for receiving keyboard focus events on a component. The
	* listener object created from that class is then registered
with a component
	* using the component's <code>addFocusListener()</code> method. When the
	* component gains or loses the keyboard focus,
the relevant method in the
	* listener object is invoked, and the <code>FocusEvent</code> is passed to it.
	*
	* @ulc.application		
	* @see		FocusEvent
	**/
 public interface IFocusListener extends java.io.Serializable, com.ulcjava.base.application.event.IEventListener
{


	/**
	* Invoked when a component gains the keyboard focus.
	*
	* @param event 		 the focus event
	**/
	 public void focusGained(com.ulcjava.base.application.event.FocusEvent event);

	/**
	* Invoked when a component loses the keyboard focus.
	*
	* @param event 		 the focus event
	**/
	 public void focusLost(com.ulcjava.base.application.event.FocusEvent event);

}