package com.ulcjava.base.application.event;


	/**
	* This interface is used to define the interaction in an
	* <code>ULCHtmlPane</code>when a link has been activated or an error occurs
	* The
<code>linkActivated(HyperlinkEvent)</code> must be implemented to react
	* onthe link value. The <code>linkError(HyperlinkEvent)</code>
must be
	* implemented to react on link errors.
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.ULCHtmlPane
	**/
 public interface IHyperlinkListener extends java.io.Serializable, com.ulcjava.base.application.event.IEventListener
{


	/**
	* Invoked when a hyperlink has been activated in the UI.
	*
	* @param event 		 the hyperlink event
	**/
	 public void linkActivated(com.ulcjava.base.application.event.HyperlinkEvent event);

	/**
	* Invoked when a hyperlink error has occurred in the UI.
	*
	* @param event 		 the hyperlink event
	**/
	 public void linkError(com.ulcjava.base.application.event.HyperlinkEvent event);

}