package com.ulcjava.base.application.event;


	/**
	* <code>IListDataListener</code>s are notified when a list's data
	* changes.
<p>
</p>
<b>Features</b>
<ul>
<li><code>IListDataListener</code>s
	* canbe registered with an <code>IListModel</code> to be notified when the
	* list's data changes.
<li>For each type of change (interval added, interval
	* removed, contents changed), a separate method is
	* called.
</ul>
<b>Examples</b><p>
</p>
The following example installs a
	* <code>IListDataListener</code> which prints some change information to the
	* console.

<pre>
DefaultListModel model = new DefaultListModel();
ULCList list
	* = new ULCList(model);
model.addListDataListener(new IListDataListener()
	* {
public void intervalAdded(ListDataEvent e)
	* {
System.out.println(&quot;intervalAdded: &quot; + e.getIndex0() + &quot;,
	* &quot;
+ e.getIndex1());
}

public void intervalRemoved(ListDataEvent e)
	* {
System.out.println(&quot;intervalRemoved: &quot; + e.getIndex0() + &quot;,
	* &quot;
+ e.getIndex1());
}

public void contentsChanged(ListDataEvent e)
	* {
System.out.println(&quot;contentsChanged: &quot; + e.getIndex0() + &quot;,
	* &quot;
+ e.getIndex1());
}
});
model.add(&quot;red&quot;);
</pre>
	*
	* @ulc.application		
	* @see		ListDataEvent
	* @see		com.ulcjava.base.application.IListModel
	**/
 public interface IListDataListener extends java.io.Serializable, com.ulcjava.base.application.event.IEventListener
{


	/**
	* Sent after the indices in the (index0, index1) interval have been inserted in
	* the data model. The new interval includes both index0
and index1.
	*
	* @param e 		 a ListDataEvent encapuslating the event information
	**/
	 public void intervalAdded(com.ulcjava.base.application.event.ListDataEvent e);

	/**
	* Sent after the indices in the (index0, index1) interval have been removed from
	* the data model. The interval includes both index0 and
index1.
	*
	* @param e 		 a ListDataEvent encapuslating the event information
	**/
	 public void intervalRemoved(com.ulcjava.base.application.event.ListDataEvent e);

	/**
	* Sent when the contents of the list has changed in a way that is too complex to
	* characterize with the previous methods. Index0 and
index1 bracket the change.
	*
	* @param e 		 a ListDataEvent encapuslating the event information
	**/
	 public void contentsChanged(com.ulcjava.base.application.event.ListDataEvent e);

}