package com.ulcjava.base.application.event;


	/**
	* <code>IListSelectionListener</code>s are notified when a list's selection
	* valuechanges.
<p>
</p>
<b>Features</b>
<ul>
<li><code>IListSelectionListener</c
	* ode>s can be registered with a <code>ULCList</code> or a
	* <code>ULCListSelectionModel</code> to
be notified when the list's selection
	* value changes</li>.
</ul>
<b>Examples</b>
<p>
</p>
The following example
	* installs an <code>IListSelectionListener</code>, which prints the selected
	* index to the console.

<pre>
ULCList list = new ULCList(new
	* MyListModel());
list.addListSelectionListener(new IListSelectionListener()
	* {
public void valueChanged(ListSelectionEvent event) {
ULCListSelectionModel
	* source =
	* (ULCListSelectionModel)event
.getSource();
System.out.println(&quot;selection
	* changed: &quot;
+ source.getMinSelectionIndex());
}
});
</pre>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.ULCListSelectionModel
	* @see		ListSelectionEvent
	**/
 public interface IListSelectionListener extends java.io.Serializable, com.ulcjava.base.application.event.IEventListener
{


	/**
	* Called whenever the value of the selection changes.
	*
	* @param event 		 the event that characterizes the change.
	**/
	 public void valueChanged(com.ulcjava.base.application.event.ListSelectionEvent event);

}