package com.ulcjava.base.application.event;


	/**
	* The listener interface for receiving server roundtrip begin and end
	* notifications. Instances of this interface can be registered via
{@link
	* com.ulcjava.base.application.ApplicationContext#addRoundTripListener(IRoundTrip
	* Listener)}. Once registered with a session, the
listener's {@link
	* #roundTripDidStart(RoundTripEvent)} method is called whenever the session
	* begins to process a client message, and its
{@link
	* #roundTripWillEnd(RoundTripEvent)} method is called when the session has
	* processed all ULC requests embedded in the message
(including all
	* <code>Runnable</code>s scheduled via {@link
	* com.ulcjava.base.server.ULCSession#invokeLater(Runnable)}).
<p>
</p>
The same
	* <code>IRoundTripListener</code> instance may be registered with multiple
	* sessions, since each <code>RoundTripEvent</code>
includes the originating
	* session as its source. <strong>In this case, the listener must be
	* thread-safe.</strong>
<p>
</p>
<strong>Note: </strong> If a class
	* implementing{@link com.ulcjava.base.application.IApplication} also
	* implements
{@link com.ulcjava.base.application.event.IRoundTripListener},
	* thensuch an <code>IApplication</code> object is implicitly added as
	* an
<code>IRoundTripListener</code> to the {@link
	* com.ulcjava.base.server.ULCSession} when the application starts.
<p>
</p>
	*
	* @ulc.application		
	**/
 public interface IRoundTripListener extends java.io.Serializable, com.ulcjava.base.application.event.IEventListener
{


	/**
	* Invoked when the round trip did start. When this method is called, {@link
	* com.ulcjava.base.server.ULCSession#currentSession()}, as
well as
	* <code>event.getSource()</code>, points to the session at which the roundtrip
	* is targeted. No client requests have been
processed yet, so the state of all
	* server-side GUI components is as of the end of the last roundtrip. It is
	* legalfor this method to
make changes to GUI components, but doing so is
	* strongly discouraged, as the server-side GUI state has not been updated yet.
	*
	* @param event 		 the round trip event, never null
	**/
	 public void roundTripDidStart(com.ulcjava.base.application.event.RoundTripEvent event);

	/**
	* Invoked when the round trip will end. When this method is called, {@link
	* com.ulcjava.base.server.ULCSession#currentSession()}, as
well as
	* <code>event.getSource()</code>, points to the session at which the roundtrip
	* is targeted. All client requests and all
<code>
Runnable</code>s scheduled
	* via<code>ULCSession.invokeLater</code> have been executed. It is legal for
	* this method to make
changes to GUI components, although care should be
	* exercised not to undo the intended effects of an <code>invokeLater</code> call.
	*
	* @param event 		 the round trip event, never null
	**/
	 public void roundTripWillEnd(com.ulcjava.base.application.event.RoundTripEvent event);

}