package com.ulcjava.base.application.event;


	/**
	* The listener interface for receiving window focus events. A class that is
	* interested in processing a window focus event implements this
interface. The
	* listener object created from that class is then registered with a
	* <code>Window</code> using the window's
<code>addWindowFocusListener()</code>
	* method. When the Window's focus is transfered into or out of the Window, the
	* relevant method in
the listener object is invoked, and the
	* <code>WindowEvent</code> is passed to it.
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.event.WindowEvent
	**/
 public interface IWindowFocusListener extends java.io.Serializable, com.ulcjava.base.application.event.IEventListener
{


	/**
	* Invoked when the window or one of its subcomponents gains the keyboard focus.
	*
	* @param e 		 the event
	**/
	 public void windowGainedFocus(com.ulcjava.base.application.event.WindowEvent e);

	/**
	* Invoked when the window or its subcomponent previously having the keyboard
	* focus, loses the keyboard focus.
	*
	* @param e 		 the event
	**/
	 public void windowLostFocus(com.ulcjava.base.application.event.WindowEvent e);

}