package com.ulcjava.base.application.event;


	/**
	* Internal frame events are events that indicate status changes of internal
	* frames. The only event type supported by the current
implementation is a
	* user's attempt to close the window. The event is passed to every
	* <code>IInternalFrameListener</code> object which
is registered to receive
	* suchevents using the <code>ULCInternalFrame</code>'s
	* <code>addInternalFrameListener()</code>
	* method.
<p>
<b>Features</b>
<ul>
<li>The <code>InternalFrameEvent</code>
	* classrepresents the event of a user attempting to close an internal
	* frame.
<li><code>IInternalFrameListener</code> defines the corresponding
	* interface consisting of the
	* single
<code>internalFrameClosing(InternalFrameEvent)</code> method which is
	* invoked when an internal frame is in the process of being
	* closed.
<li><code>InternalFrameEvent</code> and
	* <code>IInternalFrameListener</code> are typically used in connection
	* with
<code>ULCInternalFrame.setDefaultCloseOperation()</code> which allows to
	* override a <code>ULCInternalFrame</code>'s default behavior
of automatically
	* closing whenever the user attempts to close the
	* window.
</ul>
<b>Examples</b>
<p>
The following code shows how to set the
	* <code>ULCInternalFrame</code>'s default close operation to do nothing and
	* handle the event in
a specific listener that display an alert asking the user
	* if changes should be saved and deciding if the internal frame should be
	* closedor
	* not.

<pre>
internalFrame
.setDefaultCloseOperation(ULCInternalFrame.DO_NOTHING
	* _ON_CLOSE);
internalFrame.addInternalFrameListener(new CloseAction());
</pre>
	*
	* @ulc.application		
	* @see		UlcEvent
	* @see		com.ulcjava.base.application.ULCAlert
	* @see		com.ulcjava.base.application.ULCInternalFrame
	* @see		WindowEvent
	**/
 public class InternalFrameEvent extends com.ulcjava.base.application.event.UlcEvent
{


	/**
	* Constructs a InternalFrameEvent object.
	*
	* @param source 		 the ULCInternalFrame object that originated the event
	**/
	 public InternalFrameEvent(java.lang.Object source)
	{
		 super((java.lang.Object)null);
	}


	/**
	* 
	*
	* @deprecated		Use new-style event delivery mechanism instead.
	**/
	 public void dispatch(com.ulcjava.base.application.event.IEventListener l)
	{
	}


	/**
	* 
	*
	* @deprecated		Use new-style event delivery mechanism instead.
	**/
	 public int getCategory()
	{
		return 0;
	}


}