package com.ulcjava.base.application.event;


	/**
	* <code>ListDataEvents</code> describe a change in the data of an
	* <code>IListModel</code>. The event is passed to
	* every
<code>IListDataListener</code> object that registered to receive such
	* events using the component's
	* <code>addListDataListener()</code>
method.
<p>
<b>Features</b>
<ul>
<li>A
	* <code>ListDataEvent</code> carries information on the first and last row of
	* the interval whose data has changed.
<li><code>IListDataListener</code> are
	* registered with an <code>IListModel</code> to be notified when the list
	* model's data has
changed.
<li>The <code>IListDataListener</code> defines
	* methods that are called when the list model has changed, i.e., when rows have
	* been
added or removed.
</ul>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.ULCList
	* @see		com.ulcjava.base.application.IListModel
	**/
 public class ListDataEvent extends java.util.EventObject
{

	/**
	* Identifies one or more changes in the lists contents.
	*
	**/
	 public  final  static int CONTENTS_CHANGED = 0;

	/**
	* Identifies the addition of one or more contiguous items to the list.
	*
	**/
	 public  final  static int INTERVAL_ADDED = 0;

	/**
	* Identifies the removal of one or more contiguous items from the list.
	*
	**/
	 public  final  static int INTERVAL_REMOVED = 0;


	/**
	* Returns the event type. The possible values are:
<ul>
<li> {@link
	* #CONTENTS_CHANGED}
<li> {@link #INTERVAL_ADDED}
<li> {@link
	* #INTERVAL_REMOVED}</ul>
	*
	* @return		an int representing the type value
	**/
	 public int getType()
	{
		return 0;
	}


	/**
	* Returns the lower index of the range. For a single element, this value is the
	* same as that returned by {@link #getIndex1}.
	*
	* @return		an int representing the lower index value
	**/
	 public int getIndex0()
	{
		return 0;
	}


	/**
	* Returns the upper index of the range. For a single element, this value is the
	* same as that returned by {@link #getIndex0}.
	*
	* @return		an int representing the upper index value
	**/
	 public int getIndex1()
	{
		return 0;
	}


	/**
	* Constructs a ListDataEvent object.
	*
	* @param source 		 the source Object (typically <code>this</code>)
	* @param type 		 an int specifying {@link #CONTENTS_CHANGED}, {@link #INTERVAL_ADDED}, or {@link #INTERVAL_REMOVED}
	* @param index0 		 an int specifying the bottom of a range
	* @param index1 		 an int specifying the top of a range
	**/
	 public ListDataEvent(java.lang.Object source, int type, int index0, int index1)
	{
		 super((java.lang.Object)null);
	}


}