package com.ulcjava.base.application.event;


	/**
	* <code>ListSelectionEvents</code> describe a change in the selection of a
	* <code>ULCListSelectionModel</code>. The change is limited
to a row interval.
	* The event is passed to every IListSelectionListener object that registered to
	* receive such events using the model's
<code>addListSelectionListener()</code>
	* method.
<p>
<b>Features</b>
<ul>
<li>A <code>ListSelectionEvent</code>
	* carriesinformation on the first and last row of the interval whose selection
	* may have changed.
<li><code>IListSelectionListeners</code> are registered
	* witha <code>ULCListSelectionModel</code> to be notified when the selection
of
	* the corresponding component (selection in <code>ULCList</code>, row or column
	* selection in <code>ULCTable</code>, column
selection in
	* <code>ULCTableTree</code>) has changed.
<li>The
	* <code>IListSelectionListener</code> defines the <code>valueChanged()</code>
	* method which is called when the selection in the
component has changed.
</ul>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.ULCList
	* @see		com.ulcjava.base.application.ULCListSelectionModel
	* @see		com.ulcjava.base.application.ULCTable
	* @see		com.ulcjava.base.application.ULCTableTree
	**/
 public class ListSelectionEvent extends com.ulcjava.base.application.event.UlcEvent
{


	/**
	* Represents a change in selection status between firstIndex and lastIndex
	* inclusive (firstIndex is less than or equal to lastIndex).
Atleast one of the
	* rows within the range will have changed, a good ListSelectionModel
	* implementation will keep the range as small as
possible.
	*
	* @param source 		 the change selection source
	* @param firstIndex 		 The first index that changed.
	* @param lastIndex 		 The last index that changed, lastIndex >= firstIndex.
	**/
	 public ListSelectionEvent(java.lang.Object source, int firstIndex, int lastIndex)
	{
		 super((java.lang.Object)null);
	}


	/**
	* Returns the index of the first row whose selection may have changed.
	*
	* @return		The first row whose selection value may have changed, where zero is the first row
	**/
	 public int getFirstIndex()
	{
		return 0;
	}


	/**
	* Returns the index of the last row whose selection may have changed.
	*
	* @return		The last row whose selection value may have changed, where zero is the first row
	**/
	 public int getLastIndex()
	{
		return 0;
	}


	/**
	* 
	*
	* @deprecated		Use new-style event delivery mechanism instead.
	**/
	 public void dispatch(com.ulcjava.base.application.event.IEventListener listener)
	{
	}


	/**
	* 
	*
	* @deprecated		Use new-style event delivery mechanism instead.
	**/
	 public int getCategory()
	{
		return 0;
	}


}