package com.ulcjava.base.application.event;


	/**
	* A roundtrip event indicates that a well-defined state of a server roundtrip
	* hasbeen reached. Currently there are two states defined:
<ol>
<li>when the
	* roundtrip has started
<li>when the roundtrip will
	* end
</ol>
<p>
</p>
<b>Features</b>
<ul>
<li>The listener interface for this
	* event is {@link IRoundTripListener}.</li>
<li>The
	* <code>roundTripDidStart</code> event type is sent after the server has
	* received the client requests but before any of the
requests are processed by
	* the ULC framework.
<li>The <code>roundTripWillEnd</code> event type is sent
	* after all of the requests have been processed by the ULC
	* framework.
</ul>
<p>
</p>
The server roundtrip life cycle is defined as
	* follows:
</p>
<ol>
<li><code>roundTripDidStart</code> event is
	* triggered</li>
<li>client requests are
	* processed</li>
<li><code>invokeLater</code> runnables are
	* processed</li>
<li><code>roundTripWillEnd</code> event is
	* triggered</li>
</ol><p>
</p>
<b>Examples</b>
<p>
</p>
Typically a roundtrip
	* listener is added to the class
	* <code>ApplicationContext</code>.
<p>
</p>

<pre>
ApplicationContext.addRoundTri
	* pListener(new IRoundTripListener() {
public void
	* roundTripDidStart(RoundTripEvent event) {
System.out.println(&quot;Round trip
	* has started...&quot;);
}

public void roundTripWillEnd(RoundTripEvent event)
	* {System.out.println(&quot;Round trip will end...&quot;);
}
});
</pre>
	*
	* @ulc.application		
	* @see		IRoundTripListener
	* @see		com.ulcjava.base.application.ApplicationContext
	**/
 public class RoundTripEvent extends com.ulcjava.base.application.event.UlcEvent
{


	/**
	* Constructs a new instance with the specified source.
	*
	* @param source 		 the <code>ULCSession</code> targeted by this roundtrip
	**/
	 public RoundTripEvent(java.lang.Object source)
	{
		 super((java.lang.Object)null);
	}


	/**
	* Constructs a new instance with the specified source and id.
	*
	* @param source 		 the <code>ULCSession</code> targeted by this roundtrip
	* @param id 		 the event id, currently either <code>IUlcEventConstants.ROUND_TRIP_DID_START</code> or
<code>IUlcEventConstants.ROUND_TRIP_WILL_END</code>
	* @throws		NullPointerException if <code>source</code> is null
	* @throws		IllegalArgumentException if <code>id</code> is not one of <code>ROUND_TRIP_DID_START</code> or
<code>ROUND_TRIP_WILL_END</code>
	* @deprecated		Use {@link #RoundTripEvent(Object)} instead.
	**/
	 public RoundTripEvent(java.lang.Object source, int id)
	{
		 super((java.lang.Object)null);
	}


	/**
	* Invokes the <code>roundTripDidStart</code> or <code>roundTripWillEnd</code>
	* method of the specified listener, as dictated by the
event id. If the
	* listeneris not an instance of <code>IRoundTripListener</code>, this method
	* does nothing.
	*
	* @see		UlcEvent#dispatch(IEventListener)
	* @deprecated		Use new-style event delivery mechanism instead.
	**/
	 public void dispatch(com.ulcjava.base.application.event.IEventListener listener)
	{
	}


	/**
	* Returns the event id, which currently is either {@link
	* com.ulcjava.base.shared.IUlcEventConstants#ROUND_TRIP_DID_START} or
{@link
	* com.ulcjava.base.shared.IUlcEventConstants#ROUND_TRIP_WILL_END}.
	*
	* @return		the event id passed to the constructor
	* @deprecated		Ids are no longer needed and thus, no longer supported with the new-style event delivery mechanism. This method only
returns a valid id if the event object has been constructed using {@link #RoundTripEvent(Object, int)}. Otherwise, this
method returns -1.
	**/
	 public int getId()
	{
		return 0;
	}


	/**
	* Returns the category of this event, which is {@link
	* com.ulcjava.base.shared.IUlcEventConstants#ROUND_TRIP_EVENT}.
	*
	* @return		the (fixed) category of this event
	* @deprecated		Use new-style event delivery mechanism instead.
	**/
	 public int getCategory()
	{
		return 0;
	}


}