package com.ulcjava.base.application.event;


	/**
	* Tree model events are used to notify listeners that a tree model has changed.
	* The <code>TreeModelEvent</code> describes changes to
	* the
<code>ITreeModel</code>.
<p>
<b>Features</b>
<ul>
<li>The
	* <code>TreeModelEvent</code> provides information about the changes of the
	* source tree model. The
<code>ITreeModelListener</code> interface defines four
	* methods corresponding to the following types of
	* changes:
<ul>
<li><code>treeStructureChanged()</code>: the children nodes of
	* some node have been (structurally) changed. An ULCTree will in turn
refetch
	* the children count of this node and refetch all children
	* data.
<li><code>treeNodesChanged()</code>: the cell contents of certain
	* sibling nodes have changed. The nodes are addressed by specifying
their
	* parentand the children's indices. An <code>ULCTree</code> will in turn
	* refetchthe data of the affected cells if
	* currently
visible.
<li><code>treeNodesInserted()</code>: new children have
	* been inserted at some node. An <code>ULCTree</code> will in turn insert
	* the
new nodes into the view and fetch the data of the new nodes if currently
	* visible.
<li><code>treeNodesRemoved()</code>: certain children of a node have
	* been deleted. An <code>ULCTree</code> will in turn remove the
nodes from the
	* view.
</ul>
<li>Note that the <code>AbstractTreeModel</code> class provides
	* convenience methods to create and fire tree model events to all
registered
	* listeners.
</ul>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.tree.AbstractTreeModel
	* @see		com.ulcjava.base.application.ULCTree
	**/
 public class TreeModelEvent extends java.util.EventObject
{


	/**
	* Used to create an event when nodes have been changed, inserted, or
	* removed.
<p></p>
For inserts, the indexes represent the <i>final</i> state of
	* the tree, after the inserts have occurred. For deletes, the indexes
represent
	* the <i>initial</i> state of the tree, before the deletes have occurred.
	*
	* @param source 		 the source of the event
	* @param path 		 the parent of the modified children
	* @param childIndices 		 the child indices of the modified children
	* @param children 		 the modified children
	**/
	 public TreeModelEvent(java.lang.Object source, java.lang.Object[] path, int[] childIndices, java.lang.Object[] children)
	{
		 super((java.lang.Object)null);
	}


	/**
	* Used to create an event when nodes have been changed, inserted, or
	* removed.
<p></p>
For inserts, the indexes represent the <i>final</i> state of
	* the tree, after the inserts have occurred. For deletes, the indexes
represent
	* the <i>initial</i> state of the tree, before the deletes have occurred.
	*
	* @param source 		 the source of the event
	* @param path 		 the parent of the modified children
	* @param childIndices 		 the child indices of the modified children
	* @param children 		 the modified children
	**/
	 public TreeModelEvent(java.lang.Object source, com.ulcjava.base.application.tree.TreePath path, int[] childIndices, java.lang.Object[] children)
	{
		 super((java.lang.Object)null);
	}


	/**
	* Used to create an event when the node structure has changed in some way.
	*
	* @param source 		 the source of the event
	* @param path 		 the node whose structure has changed
	**/
	 public TreeModelEvent(java.lang.Object source, java.lang.Object[] path)
	{
		 super((java.lang.Object)null);
	}


	/**
	* Used to create an event when the node structure has changed in some way.
	*
	* @param source 		 the source of the event
	* @param path 		 the node whose structure has changed
	**/
	 public TreeModelEvent(java.lang.Object source, com.ulcjava.base.application.tree.TreePath path)
	{
		 super((java.lang.Object)null);
	}


	/**
	* Returns the path for the event.
	*
	* @return		the path for the event
	**/
	 public com.ulcjava.base.application.tree.TreePath getTreePath()
	{
		return null;
	}


	/**
	* Returns the children for the event.
	*
	* @return		the children for the event
	**/
	 public java.lang.Object[] getChildren()
	{
		return null;
	}


	/**
	* Returns the child indices for the event.
	*
	* @return		the child indices for the event
	**/
	 public int[] getChildIndices()
	{
		return null;
	}


}