package com.ulcjava.base.application.event;


	/**
	* Window events are events that indicate status changes of windows. The only
	* event type supported by the current implementation is a user's
attempt to
	* close the window. The event is passed to every <code>IWindowListener</code>
	* object which registered to receive such events
using the
	* <code>ULCWindow</code>'s <code>addWindowListener()</code>
	* method.
<p>
<b>Features</b>
<ul>
<li>The <code>WindowEvent</code> class
	* represents the event of a user attempting to close a
	* window.
<li><code>IWindowListener</code> defines the corresponding interface
	* consisting of the single <code>windowClosing(WindowEvent)</code>
method which
	* is invoked when a window is in the process of being
	* closed.
<li><code>WindowEvent</code> and <code>IWindowListener</code> are
	* typically used in connection
	* with
<code>ULCWindow.setDefaultCloseOperation()</code> which allows to
	* override a <code>ULCWindow</code>'s default behavior of
automatically closing
	* whenever the user attempts to close the window.
<li><code>WindowEvent</code>
	* and <code>IWindowListener</code> are also used to indicate the dismissal of a
	* <code>ULCAlert</code>.
As the server side integration does not allow the
	* executing thread to be blocked, <code>ULCAlert</code> cannot provide a
	* blocking
method that returns the user's choice as a result. Instead, a
	* listener must be added that handles the different possibilities of
	* user
choices.
</ul>
<b>Examples</b>
<p>
The following code shows how to set
	* the <code>ULCWindow</code>'s default close operation to do nothing and handle
	* the event in a
specific listener that displays an alert asking the user to
	* decide if the internal frame should be closed or
	* not.

<pre>
getFrame().setDefaultCloseOperation(ULCWindow.DO_NOTHING_ON_CLOSE);
	* getFrame().addWindowListener(new CloseAction());
</pre>

The implementation
	* ofthe application's CloseAction class checks if the user has changed any data
	* in the view and asks the user if
changes should be saved if necessary. If the
	* close action is not cancelled, the action will then close the
	* window.

<pre>
private class CloseAction implements IWindowListener {
public
	* void windowClosing(WindowEvent event) {
// If data has been changed in the
	* view, ask the user
// whether the changes should be saved.
if (isDirty())
	* {
final ULCAlert alert = new ULCAlert(&quot;Close Window&quot;,
&quot;Do you
	* want to save changes?&quot;, &quot;Yes&quot;, &quot;No&quot;,
	* &quot;Cancel&quot;);
alert.addWindowListener(new IWindowListener() {
public
	* void windowClosing(WindowEvent windowEvent) {
if
	* (alert.getValue().equals(&quot;Yes&quot;))
	* {
saveToModel();
getFrame().setVisible(false);
} else if
	* (alert.getValue().equals(&quot;No&quot;))
	* {
getFrame().setVisible(false);
}
}
});
alert.show();
} else
	* {
getFrame().setVisible(false);
}
}
}
</pre>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.ULCAlert
	* @see		com.ulcjava.base.application.ULCDialog
	* @see		UlcEvent
	* @see		com.ulcjava.base.application.ULCFrame
	* @see		com.ulcjava.base.application.ULCSlider
	**/
 public class WindowEvent extends com.ulcjava.base.application.event.UlcEvent
{


	/**
	* Constructs a WindowEvent object.
	*
	* @param source 		 the Window object that originated the event
	**/
	 public WindowEvent(java.lang.Object source)
	{
		 super((java.lang.Object)null);
	}


	/**
	* 
	*
	* @deprecated		Use new-style event delivery mechanism instead.
	**/
	 public void dispatch(com.ulcjava.base.application.event.IEventListener l)
	{
	}


	/**
	* 
	*
	* @deprecated		Use new-style event delivery mechanism instead.
	**/
	 public int getCategory()
	{
		return 0;
	}


}