package com.ulcjava.base.application.event.serializable;


	/**
	* <code>IListDataListener</code>s are notified when a list's data
	* changes.
<p>
</p>
<b>Features</b>
<ul>
<li><code>IListDataListener</code>s
	* canbe registered with an <code>IListModel</code> to be notified when the
	* list's data changes</li>.
<li>For each type of change (interval added,
	* interval removed, contents changed), a separate method is
	* called.</li>.
</ul>
<b>Examples</b> The following example installs a
	* <code>IListDataListener</code> which prints some change information to the
	* console.

<pre>
DefaultListModel model = new DefaultListModel();
ULCList list
	* = new ULCList(model);
model.addListDataListener(new IListDataListener()
	* {
public void intervalAdded(ListDataEvent e)
	* {
System.out.println(&quot;intervalAdded: &quot; + e.getIndex0() + &quot;,
	* &quot;
+ e.getIndex1());
}

public void intervalRemoved(ListDataEvent e)
	* {
System.out.println(&quot;intervalRemoved: &quot; + e.getIndex0() + &quot;,
	* &quot;
+ e.getIndex1());
}

public void contentsChanged(ListDataEvent e)
	* {
System.out.println(&quot;contentsChanged: &quot; + e.getIndex0() + &quot;,
	* &quot;
+ e.getIndex1());
}
});
model.add(&quot;red&quot;);
</pre>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.event.ListDataEvent
	* @see		com.ulcjava.base.application.IListModel
	* @deprecated		use com.ulcjava.base.application.event.IListDataListener instead
	**/
 public interface IListDataListener extends com.ulcjava.base.application.event.IListDataListener
{


}