package com.ulcjava.base.application.table;


	/**
	* The <code>DefaultTableModel</code> is an implementation of an
	* <code>ITableModel</code> that can be used for simple application
scenarios.
	* Asit keeps all its data in memory, it is suitable only where the data
	* collection is relatively small.
<p>
<b>Features</b>
<ul>
<li>The
	* <code>DefaultTableModel</code> component inherits all features of
	* <code>AbstractTableModel</code>.
<li>Manipulate the content of a
	* <code>DefaultTableModel</code> with the help of the provided
	* <code>insertRow()</code>,
<code>addRow()</code> and <code>removeRow()</code>
	* methods. To set the value of a single cell the application should use
	* the
<code>setValueAt()</code> method. The necessary table model events are
	* automatically fired when using this method.
<li>Reading the content of the
	* <code>DefaultTableModel</code> can be done with the help of the
	* <code>getValueAt()</code> method of
the <code>ITableModel</code>
	* interface.
</ul>
<b>Examples</b>
<p>
The following example shows how to fill
	* data into a <code>DefaultTableModel</code>.

<pre>
Object[] rowOne = new
	* Object[] {&quot;rowOne:columnOne&quot;,
	* &quot;rowOne:columnTwo&quot;,
&quot;rowOne:columnThree&quot;};
Object[]
	* rowTwo= new Object[] {&quot;rowTwo:columnOne&quot;,
	* &quot;rowTwo:columnTwo&quot;,
&quot;rowTwo:columnThree&quot;};
DefaultTableMode
	* l defaultTableModel = new DefaultTableModel(
new Object[0][0], new String[]
	* {&quot;column1&quot;, &quot;column2&quot;,
	* &quot;column3&quot;});
defaultTableModel.addRow(rowOne);
defaultTableModel.addR
	* ow(rowTwo);
</pre>

To read out the content of a
	* <code>DefaultTableModel</code>:

<pre>
for (int i = 0; i &lt;
	* tableModel.getRowCount(); i++) {
System.out.println(&quot;row &quot; + i +
	* &quot;: &quot; + tableModel.getValueAt(i, 0));
}
</pre>
	*
	* @ulc.application		
	* @see		AbstractTableModel
	* @see		ITableModel
	* @see		com.ulcjava.base.application.ULCTable
	**/
 public class DefaultTableModel extends com.ulcjava.base.application.table.AbstractTableModel
{


	/**
	* Constructs an empty <code>DefaultTableModel</code>.
	*
	**/
	 public DefaultTableModel()
	{
		 super();
	}


	/**
	* Constructs a <code>DefaultTableModel</code> and initializes it by setting the
	* <code>rows</code> data and the
<code>columnNames</code>.
	*
	* @param rows 		 the data of the table
	* @param columnNames 		 the names of the columns
	**/
	 public DefaultTableModel(java.lang.Object[][] rows, java.lang.String[] columnNames)
	{
		 super();
	}


	/**
	* Constructs a <code>DefaultTableModel</code> and initializes it by setting the
	* <code>rows</code> data (that must be a
<code>List</code> of
	* <code>Lists</code>) and the <code>columnNames</code>.
	*
	* @param rows 		 the data of the table (a <code>List</code> of <code>Lists</code>)
	* @param columnNames 		 a <code>List</code> containing the names of the columns
	**/
	 public DefaultTableModel(java.util.List rows, java.util.List columnNames)
	{
		 super();
	}


	/**
	* Adds a row at the end of the model. The new row will contain the data provided
	* in the <code>rowData</code> list. Tables that use
this model as their data
	* model will be notified that this row has been added.
	*
	* @param rowData 		 data of the row being added
	**/
	 public void addRow(java.util.List rowData)
	{
	}


	/**
	* Adds a row at the end of the model. The new row will contain the data provided
	* in the <code>rowData</code> array. Tables that use
this model as their data
	* model will be notified that this row has been added.
	*
	* @param rowData 		 data of the row being added
	**/
	 public void addRow(java.lang.Object[] rowData)
	{
	}

	 public int getColumnCount()
	{
		return 0;
	}

	 public java.lang.String getColumnName(int column)
	{
		return null;
	}

	 public int getRowCount()
	{
		return 0;
	}

	 public java.lang.Object getValueAt(int rowIndex, int column)
	{
		return null;
	}


	/**
	* Inserts a row at <code>row</code> in the model. The new row will contain the
	* data provided in the <code>rowData</code> list.
Tables that use this model as
	* their data model will be notified that this row has been inserted.
	*
	* @param row 		 the row index of the row to be inserted
	* @param rowData 		 data of the row being added
	**/
	 public void insertRow(int row, java.util.List rowData)
	{
	}


	/**
	* Inserts a row at <code>row</code> in the model. The new row will contain the
	* data provided in the <code>rowData</code> array.
Tables that use this model
	* astheir data model will be notified that this row has been inserted.
	*
	* @param row 		 the row index of the row to be inserted
	* @param rowData 		 data of the row being added
	**/
	 public void insertRow(int row, java.lang.Object[] rowData)
	{
	}


	/**
	* Returns true. This is the default implementation for all cells.
	*
	* @param rowIndex 		 the row being queried
	* @param columnIndex 		 the column being queried
	* @return		true
	**/
	 public boolean isCellEditable(int rowIndex, int columnIndex)
	{
		return false;
	}


	/**
	* Removes the row at <code>row</code> from the model. Tables that use this model
	* as their data model will be notified that this row
has been removed.
	*
	* @param row 		 the row index of the row to be removed
	**/
	 public void removeRow(int row)
	{
	}


	/**
	* Removes the rows between <code>startRow</code> and <code>endRow</code>.
	*
	* @param startRow 		 the start row
	* @param endRow 		 the end row
	**/
	 public void removeRows(int startRow, int endRow)
	{
	}

	 public void setValueAt(java.lang.Object value, int rowIndex, int columnIndex)
	{
	}


}