package com.ulcjava.base.application.table;


	/**
	* <code>ITableCellEditor</code> interface is implemented by the developer to
	* provide components to be used when editing table
	* cells.
<p>
<b>Features</b>
<ul>
<li>Allows definition of a component to be
	* used for editing a table cell.
<li>The component can be chosen based on row,
	* value, selection and focus states.
</ul>
<b>Examples</b>
<p>
The following
	* example sets up a convenient date editor.

<pre>
final ULCTextField dateField
	* = new ULCTextField();
dateField.setDataType(new
	* ULCDateDataType(&quot;dd.MM.yyyy&quot;));
table.getColumnModel().getColumn(Task
	* TableModel.DUE_INDEX).setCellEditor(
new ITableCellEditor() {
public
	* IEditorComponent getTableCellEditorComponent(
ULCTable table, Object value,
	* int row) {
return dateField;
}
});
</pre>
	*
	* @ulc.application		
	* @see		ITableCellRenderer
	**/
 public interface ITableCellEditor
{


	/**
	* Returns the editor component that is used to edit a table cell.
	*
	* @param table 		 the table of the cell to edit
	* @param value 		 the value of the cell to edit
	* @param row 		 the row of the cell to edit
	* @return		the editor component that is used to edit a table value
	**/
	 public com.ulcjava.base.application.IEditorComponent getTableCellEditorComponent(com.ulcjava.base.application.ULCTable table, java.lang.Object value, int row);

}