package com.ulcjava.base.application.table;


	/**
	* <code>ULCTable</code> uses the <code>ITableModel</code> interface.
	* Implementorsof this interface typically do not store the data
themselves, but
	* are adapters to some other data structure. Of course, a developer could
	* implement any arbitrary prefetching and caching
mechanism for performance
	* reasons (e.g., when data is retrieved from a SQL database to reduce the
	* numberof database queries).
<p>
<b>Features</b>
<ul>
<li>An
	* <code>ITableModel</code> encapsulates a collection of business objects. The
	* cell values of a table model are addressed by row
and column indices.
<li>A
	* table model can notify the client side that one or more cells or rows have
	* changed on the server side, triggering the UI Engine to
refresh the necessary
	* values.
<li>Table models can be shared across multiple widgets.
<li>The
	* default update mode for <code>ITableModel</code> is
	* <code>UlcEventConstants.DEFERRED_MODE</code>.
</ul>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.ULCTable
	* @see		AbstractTableModel
	**/
 public interface ITableModel extends com.ulcjava.base.application.enabler.IHasChangedSource
{


	/**
	* Returns the number of rows in the model. A <code>ULCTable</code> uses this
	* method to determine how many rows it should display.
	*
	* @return		the number of rows in the model
	* @see		#getColumnCount
	**/
	 public int getRowCount();

	/**
	* Returns the number of columns in the model. A <code>ULCTable</code> uses this
	* method to determine how many columns it should create
and display by default.
	*
	* @return		the number of columns in the model
	* @see		#getRowCount
	**/
	 public int getColumnCount();

	/**
	* Returns the name of the column at <code>column</code>. This is used to
	* initialize the table's column header name. Note: this name
does not need to
	* beunique; two columns in a table can have the same name
	*
	* @param column 		 the index of the column
	* @return		the name of the column
	**/
	 public java.lang.String getColumnName(int column);

	/**
	* Returns the most specific superclass for all the cell values in the column.
	* This is used by the <code>ULCTable</code> to set up a
default renderer and
	* editor for the column.
	*
	* @param column 		 the index of the column
	* @return		the common ancestor class of the object values in the model
	**/
	 public java.lang.Class getColumnClass(int column);

	/**
	* Returns true if the cell at <code>row</code> and <code>column</code> is
	* editable.
	*
	* @param row 		 the row whose value to be queried
	* @param column 		 the column whose value to be queried
	* @return		true if the cell is editable
	* @see		#setValueAt
	**/
	 public boolean isCellEditable(int row, int column);

	/**
	* Returns the value for the cell at <code>column</code> and <code>row</code>.
	*
	* @param row 		 the row whose value is to be queried
	* @param column 		 the column whose value is to be queried
	* @return		the value Object at the specified cell
	**/
	 public java.lang.Object getValueAt(int row, int column);

	/**
	* Sets the value in the cell at <code>column</code> and <code>row</code> to
	* <code>value</code>.
	*
	* @param value 		 the new value
	* @param row 		 the row whose value is to be changed
	* @param column 		 the column whose value is to be changed
	* @see		#getValueAt
	* @see		#isCellEditable
	**/
	 public void setValueAt(java.lang.Object value, int row, int column);

	/**
	* Adds a listener to the list that is notified each time a change to the data
	* model occurs.
	*
	* @param listener 		 the TableModelListener
	**/
	 public void addTableModelListener(com.ulcjava.base.application.event.ITableModelListener listener);

	/**
	* Removes a listener from the list that is notified each time a change to the
	* data model occurs.
	*
	* @param listener 		 the TableModelListener
	**/
	 public void removeTableModelListener(com.ulcjava.base.application.event.ITableModelListener listener);

}