package com.ulcjava.base.application.table;


	/**
	* <code>ULCTableColumnModel</code> manages table's
	* columns.
<p>
<b>Features</b>
<ul>
<li>Register
	* <code>IColumnModelListener</code>s to handle events like add, remove, or move
	* of a column.
<li>Column selection within <code>ULCTableColumnModel</code> is
	* managed by an instance of <code>ULCListSelectionModel</code>.
<li>Most of the
	* API is duplicated in the <code>ULCTable</code>, so the developer usually will
	* not need to acces
<code>ULCTableColumnModel</code> directly.
</ul>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.ULCListSelectionModel
	* @see		com.ulcjava.base.application.AbstractColumnModel
	* @see		com.ulcjava.base.application.event.IColumnModelListener
	**/
 public class ULCTableColumnModel extends com.ulcjava.base.application.AbstractColumnModel
{

	 protected java.lang.String typeString()
	{
		return null;
	}


	/**
	* Appends <code>column</code> to the end of the table columns list.
	*
	* @param column 		 the <code>ULCTableColumn</code> to be added
	**/
	 public void addColumn(com.ulcjava.base.application.table.ULCTableColumn column)
	{
	}


	/**
	* Returns the table column at the specified <code>columnIndex</code>.
	*
	* @param columnIndex 		 the index of the desired column
	* @return		the <code>ULCTableColumn</code> object for the column at <code>columnIndex</code>
	**/
	 public com.ulcjava.base.application.table.ULCTableColumn getColumn(int columnIndex)
	{
		return null;
	}


	/**
	* Returns the index of the column in the table.
	*
	* @param column 		 the column object
	* @return		the index of the column in the table
	**/
	 public int getColumnIndex(com.ulcjava.base.application.table.ULCTableColumn column)
	{
		return 0;
	}


	/**
	* Deletes <code>column</code> from the table columns list.
	*
	* @param column 		 the <code>ULCTableColumn</code> to be removed
	**/
	 public void removeColumn(com.ulcjava.base.application.table.ULCTableColumn column)
	{
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCTableColumnModelDispatcher extends AbstractColumnModelDispatcher
{


}
}