package com.ulcjava.base.application.table;


	/**
	* <code>ULCTableHeader</code> represents the header bar in a
	* table.
<p>
<b>Features</b>
<ul>
<li>An <code>IActionListener</code> can be
	* registered with the header, receiving the events when a click occurs. The
	* clicked column is
passed as a source of the event.
<li>A default renderer can
	* be set on the table header. When a header cell is to be rendered the
	* followingsteps are executed:
<ul>
<li>If there is a header renderer set on
	* column with <code>setHeaderRenderer()</code>, it is used to draw the header
	* cell, else
<li>If there is a default renderer set on the table header it is
	* used to draw the cell
<li>A default renderer is used
	* otherwise
</ul>
</ul>
<b>Examples</b>
<p>
The code below illustrates how to
	* setup an action listener on the table
	* header:

<pre>
table.getTableHeader().addActionListener(new IActionListener()
	* {
public void actionPerformed(ActionEvent event) {
ULCTableColumn source =
	* (ULCTableColumn)event.getSource();
System.out.println(&quot;column header
	* clicked: &quot;
+ source.getModelIndex());
}
});
</pre>
	*
	* @ulc.application		
	* @see		DefaultTableHeaderCellRenderer
	* @see		ITableCellRenderer
	**/
 public class ULCTableHeader extends com.ulcjava.base.application.ULCAbstractHeader
{

	 protected java.lang.String typeString()
	{
		return null;
	}

	 protected void uploadStateUI()
	{
	}


	/**
	* Constructs a <code>ULCTableHeader</code> which is initialized with a
	* <code>ULCTable</code>.
	*
	* @param table 		 the corresponding table
	**/
	 public ULCTableHeader(com.ulcjava.base.application.ULCTable table)
	{
		 super();
	}


	/**
	* Returns the default renderer used when no <code>headerRenderer</code> is
	* defined by a <code>ULCTableColumn</code>.
	*
	* @return		the default renderer
	**/
	 public com.ulcjava.base.application.table.ITableCellRenderer getDefaultRenderer()
	{
		return null;
	}


	/**
	* Sets the default renderer to be used when no <code>headerRenderer</code> is
	* defined by a <code>ULCTableColumn</code>.
	*
	* @param defaultRenderer 		 the default renderer
	**/
	 public void setDefaultRenderer(com.ulcjava.base.application.table.ITableCellRenderer defaultRenderer)
	{
	}


	/**
	* Return the table to which this header belongs.
	*
	* @return		<code>ULCTable</code>.
	**/
	 public com.ulcjava.base.application.ULCTable getTable()
	{
		return null;
	}


	/**
	* Return the table column model of the table to which this header belongs.
	*
	* @return		<code>ULCTableColumnModel</code> of the table
	**/
	 public com.ulcjava.base.application.table.ULCTableColumnModel getColumnModel()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
	 protected com.ulcjava.base.server.IDispatcher createDispatcher()
	{
		return null;
	}


	/**
	* 
	*
	* @ulc.extension		
	**/
 protected class ULCTableHeaderDispatcher extends ULCAbstractHeaderDispatcher
{


}
}