package com.ulcjava.base.application.tabletree;


	/**
	* The <code>AbstractTableTreeModel</code> class provides a default
	* implementationfor some of the methods in the
<code>ITableTreeModel</code>
	* interface. To create a table tree model, the developer usually just
	* subclasses<code>AbstractTableTreeModel</code>.
<p>
<b>Features</b>
<ul>
<li>The
	* <code>AbstractTableTreeModel</code> class manages the handling of table tree
	* model listeners.
<li>To notify the table tree model listeners that data in
	* thetable tree model has changed the application should use the
	* following
convenience methods:
<ul>
<li><code>nodeChanged()</code> when a
	* single node value has been updated,
<li><code>nodesChanged()</code> when
	* givenchildren of a node have been
	* updated,
<li><code>nodesWereInserted()</code> when children were inserted at
	* agiven node,
<li><code>nodesWereRemoved()</code> when children were removed
	* from a given node,
<li><code>nodeStructureChanged()</code> when the structure
	* below a node has been changed,
<li><code>structureChanged()</code> when
	* entirestructure has changed.
</ul>
<li>In many applications, table tree model
	* implementations are read-only and will not support writing back to the model.
	* For this reason
a default implementation of the <code>setValueAt()</code>
	* method is provided which throws an
	* <code>UnsupportedOperationException</code>.</ul>
<b>Examples</b>
<p>
The
	* following example shows how to implement a custom table tree model adapting
	* the file system on the server. When the application
itself changes the data
	* source (e.g. setting the root) the table tree model has to notify the table
	* tree model listeners. To allow
in-place editing, the
	* <code>setValueAt()</code>method has been overridden to write back the user
	* changes to the file system.

<pre>
public class FileTableTreeModel extends
	* AbstractTableTreeModel {
public static final int NAME_KEY = 0;
public static
	* final int LENGTH_KEY = 1;
public static final int HIDDEN_KEY = 2;
private
	* FilefRoot;

public FileTableTreeModel(File root) {
fRoot = root;
}

public
	* intgetChildCount(Object parent) {
File parentAsFile = (File)parent;
return
	* parentAsFile.isDirectory() ? parentAsFile.listFiles().length
: 0;
}

public
	* Object getChild(Object parent, int index) {
File parentAsFile =
	* (File)parent;
return parentAsFile.listFiles()[index];
}

public Object
	* getRoot() {
return fRoot;
}

public Object getValueAt(Object node, int
	* columnId) {
File file = (File)node;
if (columnId == NAME_KEY) {
return
	* file.getName();
} else if (columnId == LENGTH_KEY) {
return new
	* Long(file.length());
} else if (columnId == HIDDEN_KEY) {
return new
	* Boolean(file.isHidden());
} else {
throw new
	* IllegalArgumentException(
&quot;unknown column identifier: &quot; +
	* columnId);}
}

public int getIndexOfChild(Object parent, Object child) {
File
	* parentAsFile = (File)parent;
return
	* Arrays.asList(parentAsFile.listFiles()).indexOf(child);
}

// Overrides
	* default implementation in AbstractTableTreeModel.
// The default
	* implementation is invoked for non-editable columns
// (the default
	* implementation throws a UnsupportedOperationException).
public void
	* setValueAt(Object aValue, Object node, int columnId) {
File nodeAsFile =
	* (File)node;
if (node != getRoot() &amp;&amp; columnId == NAME_KEY)
	* {
nodeAsFile.renameTo(new
	* File(nodeAsFile.getParentFile(),
(String)aValue));
List pathList = new
	* ArrayList();
while ((nodeAsFile = nodeAsFile.getParentFile()) != null)
	* {
pathList.add(nodeAsFile);
}
Collections.reverse(pathList);
nodeStructureChang
	* ed(new TreePath(pathList.toArray()));
} else {
throw new
	* UnsupportedOperationException(
&quot;The file system does not allow this
	* operation.&quot;);
}
}

public int getColumnCount() {
return 3;
}

public
	* boolean isLeaf(Object node) {
return ((File)node).isFile();
}

public void
	* setRoot(File root) {
fRoot = root;
nodeStructureChanged(new
	* TreePath(root));
}
public boolean isCellEditable(Object node, int
	* columnIndex){
return columnIndex == NAME_KEY;
}
}
</pre>
	*
	* @ulc.application		
	* @see		ITableTreeModel
	* @see		com.ulcjava.base.application.ULCTableTree
	**/
 public  abstract class AbstractTableTreeModel extends java.lang.Object implements java.io.Serializable, com.ulcjava.base.application.tabletree.ITableTreeModel
{

	 protected AbstractTableTreeModel()
	{
		 super();
	}

	 public java.lang.Class getColumnClass(int column)
	{
		return null;
	}

	 public int getTreeColumn()
	{
		return 0;
	}

	 public void addTableTreeModelListener(com.ulcjava.base.application.event.ITableTreeModelListener listener)
	{
	}

	 public void removeTableTreeModelListener(com.ulcjava.base.application.event.ITableTreeModelListener listener)
	{
	}


	/**
	* Returns an array of all the table tree model listeners registered on this model.
	*
	* @return		all of this model's <code>ITableTreeModelListener</code>s or an empty array if no table model listeners are currently
registered
	* @see		#addTableTreeModelListener(ITableTreeModelListener)
	* @see		#removeTableTreeModelListener(ITableTreeModelListener)
	**/
	 public com.ulcjava.base.application.event.ITableTreeModelListener[] getTableTreeModelListeners()
	{
		return null;
	}

	 public void setValueAt(java.lang.Object value, java.lang.Object node, int column)
	{
	}


	/**
	* Returns a default name for the column using spreadsheet conventions: A, B, C,
	* ... Z, AA, AB, etc. If <code>column</code> cannot be
found, returns an empty
	* string.
	*
	* @param column 		 the column being queried
	* @return		a string containing the default name of <code>column</code>
	**/
	 public java.lang.String getColumnName(int column)
	{
		return null;
	}


	/**
	* Returns false. This is the default implementation for all cells.
	*
	* @param node 		 the node being queried
	* @param columnIndex 		 the column being queried
	* @return		false
	**/
	 public boolean isCellEditable(java.lang.Object node, int columnIndex)
	{
		return false;
	}


	/**
	* Notifies all listeners that the table tree's structure has changed. The number
	* of columns in the table tree, and the names and types
of the new columns may
	* be different from the previous state. If the <code>ULCTableTree</code>
	* receives this event and its
<code>autoCreateColumnsFromModel</code> flag is
	* set it discards any table tree columns that it had and reallocates default
	* columns
in the order they appear in the model. This is the same as calling
	* <code>setModel(ITableTreeModel)</code> on the
<code>ULCTableTree</code>.
	*
	* @see		com.ulcjava.base.application.event.TableTreeModelEvent
	**/
	 public void structureChanged()
	{
	}


	/**
	* Invoke this method after you have changed the children structure in a node.
	*
	* @param path 		 the path to the node
	**/
	 public void nodeStructureChanged(com.ulcjava.base.application.tree.TreePath path)
	{
	}


	/**
	* Invoke this method after you have inserted new children into a parent node.
	*
	* @param parentPath 		 the path to the parent node
	* @param childIndices 		 the indices of the newly inserted children nodes
	**/
	 public void nodesWereInserted(com.ulcjava.base.application.tree.TreePath parentPath, int[] childIndices)
	{
	}


	/**
	* Invoke this method after you have removed existing children from a parent node.
	*
	* @param parentPath 		 the path to the parent node
	* @param childIndices 		 the indices of the removed children nodes
	* @param removedChildren 		 the removed children nodes
	**/
	 public void nodesWereRemoved(com.ulcjava.base.application.tree.TreePath parentPath, int[] childIndices, java.lang.Object[] removedChildren)
	{
	}


	/**
	* Invoke this method after you have changed children of a parent node.
	*
	* @param parentPath 		 the path to the parent node
	* @param childIndices 		 the indices of the changed children
	**/
	 public void nodesChanged(com.ulcjava.base.application.tree.TreePath parentPath, int[] childIndices)
	{
	}


	/**
	* Invoke this method after you have changed a node.
	*
	* @param path 		 the path to the node you have changed
	**/
	 public void nodeChanged(com.ulcjava.base.application.tree.TreePath path)
	{
	}


	/**
	* Invoke this method after you have changed a single column attribute of a node.
	*
	* @param path 		 the path to the node you have changed
	* @param column 		 the column index of the changed attribute of the node
	**/
	 public void nodeChanged(com.ulcjava.base.application.tree.TreePath path, int column)
	{
	}


}