package com.ulcjava.base.application.tabletree;


	/**
	* The <code>IMutableTableTreeNode</code> interface defines the requirements for
	* an object that can be used as a mutable table tree node
in a
	* <code>DefaultTableTreeModel</code>. Note that modifying an
	* <code>IMutableTableTreeNode</code> after it is installed in
	* a
<code>DefaultTableTreeModel</code> should be done with the help of the
	* methods provided by the <code>DefaultTableTreeModel</code>
because these
	* methods automatically fire the necessary table tree
	* events.
<p>
<b>Features</b>
<ul>
<li>Modifying an
	* <code>IMutableTableTreeNode</code> can be done with the help of the
	* <code>setValueAt()</code>,
<code>insert()</code>, <code>remove()</code> and
	* <code>setParent()</code> methods.
</ul>
<b>Examples</b>
<p>
The following
	* example outlines another implementation approach of the
	* <code>AbstractTableTreeModel</code> example. Instead of a custom
table tree
	* model it implements an <code>IMutableTableTreeNode</code>.

<pre>
public
	* classFileTableTreeNode implements IMutableTableTreeNode {
public static final
	* int NAME_KEY = 0;
public static final int LENGTH_KEY = 1;
public static final
	* int HIDDEN_KEY = 2;
private final File fFile;

public FileTableTreeNode(File
	* file) {
fFile = file;
}

public Object getValueAt(int columnId) {
if
	* (columnId== NAME_KEY) {
return fFile.getName();
} else if (columnId ==
	* LENGTH_KEY) {
return new Long(fFile.length());
} else if (columnId ==
	* HIDDEN_KEY) {
return new Boolean(fFile.isHidden());
} else {
throw new
	* IllegalArgumentException(
&quot;unknown column identifier: &quot; +
	* columnId);}
}

public void setValueAt(Object aValue, int columnId) {
if
	* (columnId == NAME_KEY) {
fFile
.renameTo(new
	* File(fFile.getParentFile(),
(String)aValue));
} else if (columnId ==
	* LENGTH_KEY) {
throw new
	* UnsupportedOperationException(
&quot;FileTableTreeNodedoes not support
	* updatesfor &quot;
+ columnId);
} else if (columnId == HIDDEN_KEY) {
throw new
	* UnsupportedOperationException(
&quot;FileTableTreeNode does not support
	* updates for &quot;
+ columnId);
} else {
throw new
	* IllegalArgumentException(
&quot;unknown column identifier: &quot; +
	* columnId);}
}

public void insert(IMutableTableTreeNode newChild, int
	* childIndex) {
throw new
	* UnsupportedOperationException(
&quot;FileTableTreeNodedoes not support
	* structure changes&quot;);
}

public void remove(int childIndex) {
throw new
	* UnsupportedOperationException(
&quot;FileTableTreeNode does not support
	* structure changes&quot;);
}

public void setParent(IMutableTableTreeNode
	* newParent) {
throw new UnsupportedOperationException(
&quot;FileTableTreeNode
	* does not support structure changes&quot;);
}

public ITableTreeNode
	* getChildAt(int index) {
return new
	* FileTableTreeNode(fFile.listFiles()[index]);
}

public int getChildCount()
	* {
return fFile.isDirectory() ? fFile.listFiles().length : 0;
}

public
	* ITableTreeNode getParent() {
File parentFile = fFile.getParentFile();
if
	* (parentFile != null)
return new FileTableTreeNode(parentFile);
else
return
	* null;
}

public int getIndex(ITableTreeNode aChild) {
List children =
	* Arrays.asList(fFile.listFiles());
FileTableTreeNode fileNode =
	* (FileTableTreeNode)aChild;
return children.indexOf(fileNode.fFile);
}

public
	* String toString() {
return fFile.toString();
}

public boolean
	* isCellEditable(int column) {
return column == NAME_KEY;
}

public boolean
	* isLeaf() {
return fFile.isFile();
}
}

FileTableTreeNode rootNode = new
	* FileTableTreeNode(new
	* File(System
.getProperty(&quot;user.home&quot;)));
DefaultTableTreeModel
	* tableTreeModel = new DefaultTableTreeModel(rootNode,
new String[]
	* {&quot;Name&quot;, &quot;Length&quot;, &quot;Hidden&quot;}) {
public void
	* setValueAt(Object value, Object node, int column) {
if (column ==
	* FileTableTreeNode.NAME_KEY) {
FileTableTreeNode fileNode =
	* (FileTableTreeNode)node;
fileNode.setValueAt(value,
	* column);
nodeStructureChanged(fileNode.getParent());
}
	* else
super.setValueAt(value, node, column);
}
};
</pre>
	*
	* @ulc.application		
	* @see		ITableTreeNode
	* @see		com.ulcjava.base.application.ULCTableTree
	**/
 public interface IMutableTableTreeNode extends com.ulcjava.base.application.tabletree.ITableTreeNode
{


	/**
	* Sets the value of the node in the cell at <code>column</code> to
	* <code>value</code>. Note that calling this method does not
automatically fire
	* the corresponding table tree model event
	* (<code>DefaultTableTreeModel.setValueAt()</code> does).
	*
	* @param value 		 the new value
	* @param column 		 the column whose value is to be changed
	* @see		ITableTreeNode#getValueAt
	* @see		#isCellEditable
	**/
	 public void setValueAt(java.lang.Object value, int column);

	/**
	* Inserts <code>child</code> at location <code>index</code> into the children of
	* this node. Note that calling this method does not
automatically fire the
	* corresponding table tree model event
	* (<code>DefaultTableTreeModel.insertNodeInto()</code> does).
	*
	* @param child 		 the new child to be inserted
	* @param index 		 the target position in the children where the newChild should be inserted
	**/
	 public void insert(com.ulcjava.base.application.tabletree.IMutableTableTreeNode child, int index);

	/**
	* Removes the child at location <code>index</code> from the children of this
	* node. Note that calling this method does not
automatically fire the
	* corresponding table tree model event
	* (<code>DefaultTableTreeModel.removeNodeFromParent()</code> does).
	*
	* @param index 		 the position of the child to remove
	**/
	 public void remove(int index);

	/**
	* Sets the parent node of this node.
	*
	* @param parent 		 the new parent
	**/
	 public void setParent(com.ulcjava.base.application.tabletree.IMutableTableTreeNode parent);

	/**
	* Returns true if the node's cell at <code>column</code> is editable.
	*
	* @param column 		 the column
	* @return		true if the cell is editable
	**/
	 public boolean isCellEditable(int column);

}