package com.ulcjava.base.application.tabletree;


	/**
	* <code>ITableTreeCellEditor</code> interface is implemented by the developer to
	* provide components to be used when editing table
	* tree
cells.
<p>
<b>Features</b>
<ul>
<li>Allows definition of a component to
	* be used for editing a table tree cell.
<li>The component can be chosen based
	* on row, value, selection, expanded, leaf and focus
	* states.
</ul>
<b>Examples</b>
<p>
See {@link
	* com.ulcjava.base.application.table.ITableCellEditor} for an example.
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.table.ITableCellEditor
	* @see		ITableTreeCellRenderer
	**/
 public interface ITableTreeCellEditor
{


	/**
	* Return the editor component that is used to edit a table tree cell.
	*
	* @param tableTree 		 the table tree of the cell to edit
	* @param value 		 the value of the cell to edit
	* @param selected 		 true if the cell is selected, false otherwise
	* @param expanded 		 true if the node is expanded, false otherwise
	* @param leaf 		 true if the node is a leaf, false otherwise
	* @param node 		 the code of the cell to edit
	* @return		the editor component that is used to edit a table tree cell
	**/
	 public com.ulcjava.base.application.IEditorComponent getTableTreeCellEditorComponent(com.ulcjava.base.application.ULCTableTree tableTree, java.lang.Object value, boolean selected, boolean expanded, boolean leaf, java.lang.Object node);

}