package com.ulcjava.base.application.tabletree;


	/**
	* <code>ITableTreeCellRenderer</code> interface is implemented by the developer
	* to provide components to be used when drawing table
	* tree
cells.
<p>
<b>Features</b>
<ul>
<li>Allows definition of a component to
	* be used for drawing a table tree cell.
<li>The component can be chosen based
	* upon row, value, selection, leaf, expanded and focus
	* states.
</ul>
<b>Examples</b>
<p>
</p>
See {@link
	* com.ulcjava.base.application.IListCellRenderer} and {@link
	* com.ulcjava.base.application.table.ITableCellRenderer} for
examples.
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.IListCellRenderer
	**/
 public interface ITableTreeCellRenderer
{


	/**
	* Return the renderer component that is used to paint a table tree cell.
	*
	* @param tableTree 		 the table tree of the cell to paint
	* @param value 		 the value of the cell to paint
	* @param selected 		 true if the cell is selected, false otherwise
	* @param hasFocus 		 true if the cell has focus, false otherwise
	* @param expanded 		 true if the node is expanded, false otherwise
	* @param leaf 		 true if the node is a leaf, false otherwise
	* @param node 		 the code of the cell to paint
	* @return		the renderer component that is used to paint a table tree cell
	**/
	 public com.ulcjava.base.application.IRendererComponent getTableTreeCellRendererComponent(com.ulcjava.base.application.ULCTableTree tableTree, java.lang.Object value, boolean selected, boolean hasFocus, boolean expanded, boolean leaf, java.lang.Object node);

}