package com.ulcjava.base.application.tabletree;


	/**
	* The <code>ITableTreeModel</code> interface defines the methods the
	* <code>ULCTableTree</code> uses to read and write data. Typically,
subclasses
	* do not store the data themselves, but are adapters which redirect attempts to
	* read and write values to some other data
structure. Of course, a developer
	* could implement any arbitrary prefetching and caching mechanism for
	* performance reasons. The
<code>ITableTreeModel</code> is very similar to the
	* <code>ITableModel</code> with the addition that it also supports hierarchies
	* of
objects.
<p>
<b>Features</b>
<ul>
<li>An <code>ITableTreeModel</code>
	* encapsulates a hierarchy of business objects. The objects are addressed in a
	* hierarchical manner,
where each node has a collection of children. These
	* children are addressed by a row index. The nodes have a second dimension
	* of
addressing, where a column index defines the cell value of the node to be
	* accessed.
<li>The column index of the cell value displayed in the tree part
	* should be provided by implementing the
	* <code>getTreeColumn()</code>
method.
<li>A table tree model can notify the
	* client side that one or more cells or nodes have changed on the server side,
	* triggering the UI
Engine to refresh the corresponding values.
<li>Table tree
	* models can be shared across multiple widgets.
<li>The default update mode for
	* <code>ITableTreeModel</code> is
	* <code>UlcEventConstants.DEFERRED_MODE</code>.
</ul>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.ULCTableTree
	**/
 public interface ITableTreeModel extends com.ulcjava.base.application.enabler.IHasChangedSource
{


	/**
	* Returns the number of columns in the model.
	*
	* @return		the number of columns in the model
	**/
	 public int getColumnCount();

	/**
	* Returns the name of the column at <code>column</code>. This is used to
	* initialize the table tree's column header name. Note: this
name does not need
	* to be unique; two columns in a table tree can have the same name
	*
	* @param column 		 the index of the column
	* @return		the name of the column
	**/
	 public java.lang.String getColumnName(int column);

	/**
	* Returns the most specific superclass for all the cell values in the column.
	* This is used by the <code>ULCTableTree</code> to set up
a default renderer
	* andeditor for the column.
	*
	* @param column 		 the index of the column
	* @return		the common ancestor class of the object values in the model
	**/
	 public java.lang.Class getColumnClass(int column);

	/**
	* Returns the index of the tree column, i.e., the column that displays the tree
	* hierarchy.
	*
	* @return		the index of the tree column
	**/
	 public int getTreeColumn();

	/**
	* Returns true if the <code>node</code>'s cell at <code>column</code> is editable.
	*
	* @param node 		 the node whose value to be queried
	* @param column 		 the column whose value to be queried
	* @return		true if the cell is editable
	**/
	 public boolean isCellEditable(java.lang.Object node, int column);

	/**
	* Returns the <code>node</code>'s value for the cell at <code>column</code>.
	*
	* @param node 		 the node whose value is to be queried
	* @param column 		 the column whose value is to be queried
	* @return		the value Object at the specified cell
	**/
	 public java.lang.Object getValueAt(java.lang.Object node, int column);

	/**
	* Sets the <code>node</code>'s value in the cell at <code>column</code> to
	* <code>value</code>.
	*
	* @param value 		 the new value
	* @param node 		 the node whose value is to be changed
	* @param column 		 the column whose value is to be changed
	**/
	 public void setValueAt(java.lang.Object value, java.lang.Object node, int column);

	/**
	* Returns the root of the table tree model.
	*
	* @return		the root of the table tree model
	**/
	 public java.lang.Object getRoot();

	/**
	* Returns the child of <code>parent</code> at index <code>index</code> in the
	* parent's child array.
	*
	* @param parent 		 a node in the table tree model, obtained from this model
	* @param index 		 the position of the child requested
	* @return		the child of <code>parent</code> at index <code>index</code>
	**/
	 public java.lang.Object getChild(java.lang.Object parent, int index);

	/**
	* Returns the number of children of <code>parent</code>. Returns 0 if the node
	* isa leaf or if it has no children.
	*
	* @param parent 		 a node in the table tree, obtained from this model
	* @return		the number of children of the node <code>parent</code>
	**/
	 public int getChildCount(java.lang.Object parent);

	/**
	* Returns true if <code>node</code> is a leaf. It is possible for this method to
	* return false even if <code>node</code> has no
children (e.g., empty directory
	* in a filesystem is not a leaf but has no children).
	*
	* @param node 		 a node in the table tree, obtained from this model
	* @return		true if <code>node</code> is a leaf, false otherwise
	**/
	 public boolean isLeaf(java.lang.Object node);

	/**
	* Returns the index of <code>child</code> in <code>parent</code>.
	*
	* @param parent 		 the parent of child
	* @param child 		 the child the index is queried for
	* @return		the index of the child specified
	**/
	 public int getIndexOfChild(java.lang.Object parent, java.lang.Object child);

	/**
	* Adds a listener for <code>TableTreeModelEvents</code> posted after the table
	* tree model changes.
	*
	* @param listener 		 the listener to add
	**/
	void addTableTreeModelListener(com.ulcjava.base.application.event.ITableTreeModelListener listener);

	/**
	* Removes a listener for <code>TableTreeModelEvents</code>.
	*
	* @param listener 		 the listener to remove
	**/
	void removeTableTreeModelListener(com.ulcjava.base.application.event.ITableTreeModelListener listener);

}