package com.ulcjava.base.application.tree;


	/**
	* The <code>DefaultMutableTreeNode</code> is an implementation of an
	* <code>IMutableTreeNode</code>. It is suitable for very simple
applications
	* where the amount of data is relatively
	* small.
<p>
<b>Features</b>
<ul>
<li>The<code>DefaultMutableTreeNode</code>
	* class manages the handling of the parent and the children.
<li>A default
	* implementation of the <code>setValueAt()</code> method is provided which
	* throws an
<code>UnsupportedOperationException</code>.
</ul>
	*
	* @ulc.application		
	* @see		IMutableTreeNode
	**/
 public class DefaultMutableTreeNode extends java.lang.Object implements java.io.Serializable, com.ulcjava.base.application.tree.IMutableTreeNode
{


	/**
	* Creates a node that has no user object and is not a leaf.
	*
	**/
	 public DefaultMutableTreeNode()
	{
		 super();
	}


	/**
	* Creates a node that is not a leaf.
	*
	* @param userObject 		 the user object for the node
	**/
	 public DefaultMutableTreeNode(java.lang.Object userObject)
	{
		 super();
	}


	/**
	* Creates a node.
	*
	* @param userObject 		 the user object for the node
	* @param leaf 		 specifies if the node should be a leaf or not
	**/
	 public DefaultMutableTreeNode(java.lang.Object userObject, boolean leaf)
	{
		 super();
	}


	/**
	* Removes the specified child from its parent and makes it a child of this node.
	*
	* @param child 		 the node to add to this node
	**/
	 public void add(com.ulcjava.base.application.tree.IMutableTreeNode child)
	{
	}

	 public com.ulcjava.base.application.tree.ITreeNode getChildAt(int index)
	{
		return null;
	}

	 public int getChildCount()
	{
		return 0;
	}

	 public int getIndex(com.ulcjava.base.application.tree.ITreeNode child)
	{
		return 0;
	}

	 public com.ulcjava.base.application.tree.ITreeNode getParent()
	{
		return null;
	}


	/**
	* Returns the path to the root.
	*
	* @return		the path to the root
	**/
	 public com.ulcjava.base.application.tree.ITreeNode[] getPath()
	{
		return null;
	}


	/**
	* Returns the user object.
	*
	* @return		the user object
	**/
	 public java.lang.Object getUserObject()
	{
		return null;
	}

	 public void insert(com.ulcjava.base.application.tree.IMutableTreeNode child, int index)
	{
	}

	 public boolean isLeaf()
	{
		return false;
	}


	/**
	* Returns true if the specified node is an ancestor of this node, false otherwise.
	*
	* @param node 		 the node to test
	* @return		true if the specified node is an ancestor of this node, false otherwise
	**/
	 public boolean isNodeAncestor(com.ulcjava.base.application.tree.ITreeNode node)
	{
		return false;
	}

	 public void remove(int index)
	{
	}


	/**
	* Removes all children.
	*
	**/
	 public void removeAllChildren()
	{
	}


	/**
	* Determines whether or not this node is a leaf. If leaf is true, all of this
	* node's children are removed.
	*
	* @param leaf 		 true if this node is a leaf, false otherwise
	**/
	 public void setLeaf(boolean leaf)
	{
	}

	 public void setParent(com.ulcjava.base.application.tree.IMutableTreeNode parent)
	{
	}

	 public void setUserObject(java.lang.Object userObject)
	{
	}

	 public java.lang.String toString()
	{
		return null;
	}


}