package com.ulcjava.base.application.tree;


	/**
	* The <code>DefaultTreeModel</code> is an implementation of a tree model that
	* uses <code>ITreeNodes</code>.
<p>
<b>Features</b>
<ul>
<li>The
	* <code>DefaultTreeModel</code> component inherits all features of
	* <code>AbstractTreeModel</code>.
<li>It provides a tree model implementation
	* that uses <code>ITreeNodes</code>.
<li>Manipulate the content of a
	* <code>DefaultTreeModel</code> with the help of the provided
	* <code>insertNodeInto()</code> and
<code>removeNodeFromParent()</code>
	* methods.To set the value of a single node the application should use
	* the
<code>valueForPathChanged()</code> method of the <code>ITreeModel</code>
	* interface. When using these methods the necessary table
model events are
	* automatically fired. Note that adding and removing children to and from a
	* nodein a <code>DefaultTreeModel</code> is
only possible if this node is an
	* <code>IMutableTreeNode</code>.
<li>Reading the content of the
	* <code>DefaultTreeModel</code> can be done with the help of the various getter
	* methods of the
<code>ITreeModel</code> interface.
</ul>
	*
	* @ulc.application		
	* @see		AbstractTreeModel
	**/
 public class DefaultTreeModel extends com.ulcjava.base.application.tree.AbstractTreeModel
{


	/**
	* Creates a new tree model that delegates all callback methods to corresponding
	* methods on its <code>ITreeNode</code> objects.
	*
	* @param root 		 the root of the tree
	**/
	 public DefaultTreeModel(com.ulcjava.base.application.tree.ITreeNode root)
	{
		 super();
	}

	 public java.lang.Object getChild(java.lang.Object parent, int index)
	{
		return null;
	}

	 public int getChildCount(java.lang.Object parent)
	{
		return 0;
	}

	 public int getIndexOfChild(java.lang.Object parent, java.lang.Object child)
	{
		return 0;
	}


	/**
	* Returns the path to the root.
	*
	* @param node 		 the node to get the path for
	* @return		the path to the root
	**/
	 public  static com.ulcjava.base.application.tree.ITreeNode[] getPathToRoot(com.ulcjava.base.application.tree.ITreeNode node)
	{
		return null;
	}

	 public java.lang.Object getRoot()
	{
		return null;
	}


	/**
	* Inserts the specified child into the specified parent at the specified index.
	*
	* @param child 		 the child to insert
	* @param parent 		 the parent to insert the child into
	* @param index 		 the index to insert the child at
	**/
	 public void insertNodeInto(com.ulcjava.base.application.tree.IMutableTreeNode child, com.ulcjava.base.application.tree.IMutableTreeNode parent, int index)
	{
	}

	 public boolean isLeaf(java.lang.Object node)
	{
		return false;
	}


	/**
	* Invoke this method after you have changed a node.
	*
	* @param node 		 the node you have changed
	**/
	 public void nodeChanged(com.ulcjava.base.application.tree.ITreeNode node)
	{
	}


	/**
	* Invoke this method after you have changed children of a parent node.
	*
	* @param parent 		 the parent node
	* @param childIndices 		 the indices of the changed children
	**/
	 public void nodesChanged(com.ulcjava.base.application.tree.ITreeNode parent, int[] childIndices)
	{
	}


	/**
	* Invoke this method after you have changed the children structure in a node.
	*
	* @param node 		 the node
	**/
	 public void nodeStructureChanged(com.ulcjava.base.application.tree.ITreeNode node)
	{
	}


	/**
	* Invoke this method after you have inserted new children into a parent node.
	*
	* @param parent 		 the parent node
	* @param childIndices 		 the indices of the newly inserted children nodes
	**/
	 public void nodesWereInserted(com.ulcjava.base.application.tree.ITreeNode parent, int[] childIndices)
	{
	}


	/**
	* Invoke this method after you have removed existing children form a parent node.
	*
	* @param parent 		 the parent node
	* @param childIndices 		 the indices of the removed children nodes
	* @param removedChildren 		 the removed children nodes
	**/
	 public void nodesWereRemoved(com.ulcjava.base.application.tree.ITreeNode parent, int[] childIndices, java.lang.Object[] removedChildren)
	{
	}


	/**
	* Removes the specified node from its parent.
	*
	* @param node 		 the node to be removed
	**/
	 public void removeNodeFromParent(com.ulcjava.base.application.tree.IMutableTreeNode node)
	{
	}


	/**
	* Sets the root.
	*
	* @param root 		 the new root
	**/
	 public void setRoot(com.ulcjava.base.application.tree.ITreeNode root)
	{
	}

	 public void valueForPathChanged(com.ulcjava.base.application.tree.TreePath path, java.lang.Object value)
	{
	}


}