package com.ulcjava.base.application.tree;


	/**
	* The <code>IMutableTreeNode</code> interface defines the requirements for an
	* object that can be used as a mutable tree node in
	* a
<code>DefaultTreeModel</code>. Note that modifying an
	* <code>IMutableTreeNode</code> after it is installed in
	* a
<code>DefaultTreeModel</code> should be done with the help of the methods
	* provided by the <code>DefaultTreeModel</code> because these
methods
	* automatically fire the necessary tree
	* events.
<p>
<b>Features</b>
<ul>
<li>Modify of an
	* <code>IMutableTreeNode</code> using the <code>setUserObject()</code>,
	* <code>insert()</code>,
<code>remove()</code> and <code>setParent()</code>
	* methods.
</ul>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.tabletree.IMutableTableTreeNode
	* @see		DefaultTreeModel
	**/
 public interface IMutableTreeNode extends com.ulcjava.base.application.tree.ITreeNode
{


	/**
	* Adds the specified child to the node at the specified index.
	*
	* @param child 		 the child to insert
	* @param index 		 the index to insert the child at
	**/
	 public void insert(com.ulcjava.base.application.tree.IMutableTreeNode child, int index);

	/**
	* Removes the child at the specified index from the node.
	*
	* @param index 		 the index of the child to be removed
	**/
	 public void remove(int index);

	/**
	* Sets the user object of the node to the specified user object.
	*
	* @param userObject 		 the new user object
	**/
	 public void setUserObject(java.lang.Object userObject);

	/**
	* Sets the parent of the node to the specified parent.
	*
	* @param parent 		 the new parent
	**/
	 public void setParent(com.ulcjava.base.application.tree.IMutableTreeNode parent);

}