package com.ulcjava.base.application.tree;


	/**
	* <code>ITreeCellRenderer</code> interface provides components to draw tree
	* nodes.
<p>
<b>Features</b>
<ul>
<li>Allows definition of a component to be
	* used for drawing a tree node.
<li>The component can be chosen based on value,
	* selection, leaf, expanded and focus states.
</ul>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.IListCellRenderer
	**/
 public interface ITreeCellRenderer
{


	/**
	* Return the renderer component that is used to paint a tree node.
	*
	* @param tree 		 the tree of the node to paint
	* @param value 		 the value of the node to paint
	* @param selected 		 true if the node is selected, false otherwise
	* @param hasFocus 		 true if the node has focus, false otherwise
	* @param expanded 		 true if the node is expanded, false otherwise
	* @param leaf 		 true if the node is a leaf, false otherwise
	* @return		the renderer component that is used to paint a tree node
	**/
	com.ulcjava.base.application.IRendererComponent getTreeCellRendererComponent(com.ulcjava.base.application.ULCTree tree, java.lang.Object value, boolean selected, boolean expanded, boolean leaf, boolean hasFocus);

}