package com.ulcjava.base.application.tree;


	/**
	* The <code>ITreeModel</code> interface defines the methods the
	* <code>ULCTree</code> uses to read and write data. Typically, subclasses
do
	* notstore the data themselves, but are adapters that redirect attempts to read
	* and write values to some other data structure. Of
course, a developer could
	* implement any arbitrary prefetching and caching mechanism for performance
	* reasons.
<p>
</p>
<b>Features</b>
<ul>
<li>An <code>ITreeModel</code>
	* encapsulates a hierarchy of business objects. The objects are addressed in a
	* hierarchical manner, where
each node has a collection of children. These
	* children are addressed by a child index.
<li>A tree model can notify the
	* client side that one or more cells or nodes have changed on the server side,
	* triggering the UI Engine to
refresh the corresponding values.
<li>Tree models
	* can be shared across multiple widgets.
<li>The default update mode for
	* <code>ITreeModel</code> is
	* <code>UlcEventConstants.DEFERRED_MODE</code>.
</ul><b>Examples</b>
<p>
</p>
The
	* following example prints all nodes of a tree model.

<pre>
private void
	* printOutModel(ITreeModel model) {
printOutNode(model, model.getRoot(),
	* &quot;&quot;);
}

private void printOutNode(ITreeModel model, Object node,
	* String indent) {
System.out.println(indent + node);
for (int i = 0; i &lt;
	* model.getChildCount(node); i++) {
printOutNode(model, model.getChild(node,
	* i),indent + '\t');
}
}
</pre>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.ULCTree
	**/
 public interface ITreeModel extends com.ulcjava.base.application.enabler.IHasChangedSource
{


	/**
	* Returns the root of the tree. Returns null only if the tree has no nodes.
	*
	* @return		the root of the tree
	**/
	 public java.lang.Object getRoot();

	/**
	* Returns the child of <I>parent</I> at index <I>index</I> in the parent's child
	* array. <I>parent</I> must be a node previously
obtained from this data
	* source.This should not return null if <i>index</i> is a valid index for
	* <i>parent</i> (that is <i>index</i> >=
0 && <i>index</i> <
	* getChildCount(<i>parent</i>)).
	*
	* @param parent 		 a node in the tree, obtained from this data source
	* @param index 		 the index
	* @return		the child of <I>parent</I> at index <I>index</I>
	**/
	 public java.lang.Object getChild(java.lang.Object parent, int index);

	/**
	* Returns the number of children of <I>parent</I>. Returns 0 if the node is a
	* leaf or if it has no children. <I>parent</I> must be a
node previously
	* obtained from this data source.
	*
	* @param parent 		 a node in the tree, obtained from this data source
	* @return		the number of children of the node <I>parent</I>
	**/
	 public int getChildCount(java.lang.Object parent);

	/**
	* Returns true if <I>node</I> is a leaf. It is possible for this method to
	* returnfalse even if <I>node</I> has no children. A
directory in a filesystem,
	* for example, may contain no files; the node representing the directory is not
	* a leaf, but it also has no
children.
	*
	* @param node 		 a node in the tree, obtained from this data source
	* @return		true if <I>node</I> is a leaf
	**/
	 public boolean isLeaf(java.lang.Object node);

	/**
	* Messaged when the user has altered the value for the item identified by
	* <I>path</I> to <I>newValue</I>. If <I>newValue</I>
signifies a truly new
	* valuethe model should post a treeNodesChanged event.
	*
	* @param path 		 path to the node that the user has altered.
	* @param value 		 the new value from the TreeCellEditor.
	**/
	 public void valueForPathChanged(com.ulcjava.base.application.tree.TreePath path, java.lang.Object value);

	/**
	* Returns the index of the specified child in the specified parent.
	*
	* @param parent 		 the parent
	* @param child 		 the child
	* @return		the index of the specified child in the specified parent
	**/
	 public int getIndexOfChild(java.lang.Object parent, java.lang.Object child);

	/**
	* Adds a listener for the TreeModelEvent posted after the tree changes.
	*
	* @param listener 		 the listener to add
	* @see		#removeTreeModelListener
	**/
	void addTreeModelListener(com.ulcjava.base.application.event.ITreeModelListener listener);

	/**
	* Removes a listener previously added with <B>addTreeModelListener()</B>.
	*
	* @param listener 		 the listener to remove
	* @see		#addTreeModelListener
	**/
	void removeTreeModelListener(com.ulcjava.base.application.event.ITreeModelListener listener);

}