package com.ulcjava.base.application.tree;


	/**
	* The <code>ITreeNode</code> interface defines the requirements for an object
	* that can be used as an immutable tree node in
	* a
<code>DefaultTreeModel</code>.<p>
<b>Features</b>
<ul>
<li>An
	* <code>ITreeNode</code> encapsulates one business object.
<li>An
	* <code>ITreeNode</code> can return its children and its parent.
</ul>
	*
	* @ulc.application		
	* @see		DefaultTreeModel
	**/
 public interface ITreeNode
{


	/**
	* Returns the child at index <code>index</code>.
	*
	* @param index 		 the index of the child
	* @return		the child at index <code>index</code>
	**/
	 public com.ulcjava.base.application.tree.ITreeNode getChildAt(int index);

	/**
	* Returns the number of children.
	*
	* @return		the number of children
	**/
	 public int getChildCount();

	/**
	* Returns the parent.
	*
	* @return		the parent
	**/
	 public com.ulcjava.base.application.tree.ITreeNode getParent();

	/**
	* Returns the index of <code>child</code>. If the <code>child</code> is not a
	* child, -1 will be returned.
	*
	* @param child 		 the child
	* @return		the index of <code>node</code>
	**/
	 public int getIndex(com.ulcjava.base.application.tree.ITreeNode child);

	/**
	* Returns true if the node is a leaf, false otherwise.
	*
	* @return		true if the node is a leaf, false otherwise
	**/
	 public boolean isLeaf();

}