package com.ulcjava.base.application.util;


	/**
	* The <code>AffineTransform</code> class represents a 2D affine transform that
	* performs a linear mapping from 2D coordinates to other 2D
coordinates that
	* preserves the "straightness" and "parallelness" of
	* lines.
<p>
</p>
<b>Features</b>
<ul>
<li>Affine transformations can be
	* constructed using sequences of translations, scales, flips, rotations, and
	* shears.
<li>Affine transformations are performed server-side. When a Font is
	* concerned with a transformation, the matrix is passed to the client
via the
	* <code>setFont()</code> call during a client-server round-trip.
<li>A
	* coordinate transformation can be represented by a 3 row by 3 column matrix
	* with an implied last row of [ 0 0 1 ]. This matrix
transforms source
	* coordinates <code>(x,&nbsp;y)</code> into destination coordinates
	* <code>(x',&nbsp;y')</code> by considering them to
be a column vector and
	* multiplying the coordinate vector by the matrix according to the following
	* process:

<pre>
[ x'] [ m00 m01 m02 ] [ x ] [ m00x + m01y + m02 ]
[ y'] = [
	* m10 m11 m12 ] [ y ] = [ m10x + m11y + m12 ]
[ 1 ] [ 0 0 1 ] [ 1 ] [ 1
	* ]
</pre>
<p>
</p>
<b>Examples</b>
<p>
The following code snippet shows the
	* useof <code>AffineTransform</code> transformations related to the
	* <code>Font.deriveFont()</code>
method.

<pre>
ULCBoxPane pane = new
	* ULCBoxPane();
Font font24 = new Font(&quot;Serif&quot;, Font.PLAIN,
	* 24);
AffineTransform atRotation = new
	* AffineTransform();
atRotation.rotate(.14);
Font font24rotation =
	* font24.deriveFont(atRotation);
ULCLabel label = new ULCLabel(&quot;font24
	* withrotation&quot;);
label.setFont(font24rotation);
pane.add(label);
</pre>
	*
	* @ulc.application		
	* @see		Font
	**/
 public class AffineTransform extends java.lang.Object implements java.io.Serializable
{

	/**
	* This constant indicates that the transform defined by this object is an
	* identity transform. An identity transform is one in which the
output
	* coordinates are always the same as the input coordinates. If this transform
	* isanything other than the identity transform, the
type will either be the
	* constant GENERAL_TRANSFORM or a combination of the appropriate flag bits for
	* the various coordinate
conversions that this transform performs.
	*
	**/
	 public  final  static int TYPE_IDENTITY = 0;

	/**
	* This flag bit indicates that the transform defined by this object performs a
	* translation in addition to the conversions indicated by
other flag bits. A
	* translation moves the coordinates by a constant amount in x and y without
	* changing the length or angle of vectors.
	*
	**/
	 public  final  static int TYPE_TRANSLATION = 0;

	/**
	* This flag bit indicates that the transform defined by this object performs a
	* uniform scale in addition to the conversions indicated
by other flag bits. A
	* uniform scale multiplies the length of vectors by the same amount in both the
	* x and y directions without
changing the angle between vectors. This flag bit
	* is mutually exclusive with the TYPE_GENERAL_SCALE flag.
	*
	**/
	 public  final  static int TYPE_UNIFORM_SCALE = 0;

	/**
	* This flag bit indicates that the transform defined by this object performs a
	* general scale in addition to the conversions indicated
by other flag bits. A
	* general scale multiplies the length of vectors by different amounts in the x
	* and y directions without changing
the angle between perpendicular vectors.
	* This flag bit is mutually exclusive with the TYPE_UNIFORM_SCALE flag.
	*
	**/
	 public  final  static int TYPE_GENERAL_SCALE = 0;

	/**
	* This constant is a bit mask for any of the scale flag bits.
	*
	**/
	 public  final  static int TYPE_MASK_SCALE = 0;

	/**
	* This flag bit indicates that the transform defined by this object performs a
	* mirror image flip about some axis which changes the
normally right handed
	* coordinate system into a left handed system in addition to the conversions
	* indicated by other flag bits. A
right handed coordinate system is one where
	* the positive X axis rotates counterclockwise to overlay the positive Y axis
	* similar to
the direction that the fingers on your right hand curl when you
	* stare end on at your thumb. A left handed coordinate system is one
where the
	* positive X axis rotates clockwise to overlay the positive Y axis similar to
	* the direction that the fingers on your left
hand curl. There is no
	* mathematical way to determine the angle of the original flipping or mirroring
	* transformation since all angles
of flip are identical given an appropriate
	* adjusting rotation.
	*
	**/
	 public  final  static int TYPE_FLIP = 0;

	/**
	* This flag bit indicates that the transform defined by this object performs a
	* quadrant rotation by some multiple of 90 degrees in
addition to the
	* conversions indicated by other flag bits. A rotation changes the angles of
	* vectors by the same amount regardless of
the original direction of the vector
	* and without changing the length of the vector. This flag bit is mutually
	* exclusive with the
TYPE_GENERAL_ROTATION flag.
	*
	**/
	 public  final  static int TYPE_QUADRANT_ROTATION = 0;

	/**
	* This flag bit indicates that the transform defined by this object performs a
	* rotation by an arbitrary angle in addition to the
conversions indicated by
	* other flag bits. A rotation changes the angles of vectors by the same amount
	* regardless of the original
direction of the vector and without changing the
	* length of the vector. This flag bit is mutually exclusive with
	* the
TYPE_QUADRANT_ROTATION flag.
	*
	**/
	 public  final  static int TYPE_GENERAL_ROTATION = 0;

	/**
	* This constant is a bit mask for any of the rotation flag bits.
	*
	**/
	 public  final  static int TYPE_MASK_ROTATION = 0;

	/**
	* This constant indicates that the transform defined by this object performs an
	* arbitrary conversion of the input coordinates. If this
transform can be
	* classified by any of the above constants, the type will either be the
	* constantTYPE_IDENTITY or a combination of the
appropriate flag bits for the
	* various coordinate conversions that this transform performs.
	*
	**/
	 public  final  static int TYPE_GENERAL_TRANSFORM = 0;

	 private AffineTransform(double m00, double m10, double m01, double m11, double m02, double m12, int state)
	{
		 super();
	}


	/**
	* Constructs a new <code>AffineTransform</code> representing the Identity
	* transformation.
	*
	**/
	 public AffineTransform()
	{
		 super();
	}


	/**
	* Constructs a new <code>AffineTransform</code> that is a copy of the specified
	* <code>AffineTransform</code> object.
	*
	* @param Tx 		 the <code>AffineTransform</code> object to copy
	**/
	 public AffineTransform(com.ulcjava.base.application.util.AffineTransform Tx)
	{
		 super();
	}


	/**
	* Constructs a new <code>AffineTransform</code> from 6 floating point values
	* representing the 6 specifiable entries of the 3x3
transformation matrix.
	*
	* @param m00 		 one of the 6 floating point values that compose the 3x3 transformation matrix
	* @param m01 		 one of the 6 floating point values that compose the 3x3 transformation matrix
	* @param m02 		 one of the 6 floating point values that compose the 3x3 transformation matrix
	* @param m10 		 one of the 6 floating point values that compose the 3x3 transformation matrix
	* @param m11 		 one of the 6 floating point values that compose the 3x3 transformation matrix
	* @param m12 		 one of the 6 floating point values that compose the 3x3 transformation matrix
	**/
	 public AffineTransform(float m00, float m10, float m01, float m11, float m02, float m12)
	{
		 super();
	}


	/**
	* Constructs a new <code>AffineTransform</code> from an array of floating point
	* values representing either the 4 non-translation
enries or the 6 specifiable
	* entries of the 3x3 transformation matrix. The values are retrieved from the
	* array as
{&nbsp;m00&nbsp;m10&nbsp;m01&nbsp;m11&nbsp;[m02&nbsp;m12]}.
	*
	* @param flatmatrix 		 the float array containing the values to be set in the new <code>AffineTransform</code> object. The length of the
array is assumed to be at least 4. If the length of the array is less than 6, only the first 4 values are taken. If the
length of the array is greater than 6, the first 6 values are taken.
	**/
	 public AffineTransform(float[] flatmatrix)
	{
		 super();
	}


	/**
	* Constructs a new <code>AffineTransform</code> from 6 double precision values
	* representing the 6 specifiable entries of the 3x3
transformation matrix.
	*
	* @param m00 		 one of the 6 floating point values that compose the 3x3 transformation matrix
	* @param m01 		 one of the 6 floating point values that compose the 3x3 transformation matrix
	* @param m02 		 one of the 6 floating point values that compose the 3x3 transformation matrix
	* @param m10 		 one of the 6 floating point values that compose the 3x3 transformation matrix
	* @param m11 		 one of the 6 floating point values that compose the 3x3 transformation matrix
	* @param m12 		 one of the 6 floating point values that compose the 3x3 transformation matrix
	**/
	 public AffineTransform(double m00, double m10, double m01, double m11, double m02, double m12)
	{
		 super();
	}


	/**
	* Constructs a new <code>AffineTransform</code> from an array of double
	* precisionvalues representing either the 4 non-translation
entries or the 6
	* specifiable entries of the 3x3 transformation matrix. The values are
	* retrievedfrom the array
	* as
{&nbsp;m00&nbsp;m10&nbsp;m01&nbsp;m11&nbsp;[m02&nbsp;m12]}.
	*
	* @param flatmatrix 		 the double array containing the values to be set in the new <code>AffineTransform</code> object. The length of
the array is assumed to be at least 4. If the length of the array is less than 6, only the first 4 values are taken. If
the length of the array is greater than 6, the first 6 values are taken.
	**/
	 public AffineTransform(double[] flatmatrix)
	{
		 super();
	}


	/**
	* Returns a transform representing a translation transformation. The matrix
	* representing the returned transform is:

<pre>
[ 1 0 tx ]
[ 0 1 ty ]
[ 0 0 1
	* ]</pre>
	*
	* @param tx 		 the distance by which coordinates are translated in the X axis direction
	* @param ty 		 the distance by which coordinates are translated in the Y axis direction
	* @return		an <code>AffineTransform</code> object that represents a translation transformation, created with the specified vector.
	**/
	 public  static com.ulcjava.base.application.util.AffineTransform getTranslateInstance(double tx, double ty)
	{
		return null;
	}


	/**
	* Returns a transform representing a rotation transformation. The matrix
	* representing the returned transform is:

<pre>
[ cos(theta) -sin(theta) 0 ]
[
	* sin(theta) cos(theta) 0 ]
[ 0 0 1 ]
</pre>

Rotating with a positive angle
	* theta rotates points on the positive x axis toward the positive y axis.
	*
	* @param theta 		 the angle of rotation in radians
	* @return		an <code>AffineTransform</code> object that is a rotation transformation, created with the specified angle of rotation.
	**/
	 public  static com.ulcjava.base.application.util.AffineTransform getRotateInstance(double theta)
	{
		return null;
	}


	/**
	* Returns a transform that rotates coordinates around an anchor point. This
	* operation is equivalent to translating the coordinates so
that the anchor
	* point is at the origin (S1), then rotating them about the new origin (S2),
	* andfinally translating so that the
intermediate origin is restored to the
	* coordinates of the original anchor point (S3).
<p>
</p>
This operation is
	* equivalent to the following sequence of calls:

<pre>
AffineTransform Tx =
	* newAffineTransform();
Tx.setToTranslation(x, y); // S3: final
	* translation
Tx.rotate(theta); // S2: rotate around anchor
Tx.translate(-x,
	* -y); // S1: translate anchor to origin
</pre>

The matrix representing the
	* returned transform is:

<pre>
[ cos(theta) -sin(theta) x-x*cos+y*sin ]
[
	* sin(theta) cos(theta) y-x*sin-y*cos ]
[ 0 0 1 ]
</pre>

Rotating with a
	* positive angle theta rotates points on the positive x axis toward the
	* positivey axis.
	*
	* @param theta 		 the angle of rotation in radians
	* @param x 		 the coordinates of the anchor point of the rotation
	* @param y 		 the coordinates of the anchor point of the rotation
	* @return		an <code>AffineTransform</code> object that rotates coordinates around the specified point by the specified angle of
rotation.
	**/
	 public  static com.ulcjava.base.application.util.AffineTransform getRotateInstance(double theta, double x, double y)
	{
		return null;
	}


	/**
	* Returns a transform representing a scaling transformation. The matrix
	* representing the returned transform is:

<pre>
[ sx 0 0 ]
[ 0 sy 0 ]
[ 0 0 1
	* ]</pre>
	*
	* @param sx 		 the factor by which coordinates are scaled along the X axis direction
	* @param sy 		 the factor by which coordinates are scaled along the Y axis direction
	* @return		an <code>AffineTransform</code> object that scales coordinates by the specified factors.
	**/
	 public  static com.ulcjava.base.application.util.AffineTransform getScaleInstance(double sx, double sy)
	{
		return null;
	}


	/**
	* Returns a transform representing a shearing transformation. The matrix
	* representing the returned transform is:

<pre>
[ 1 shx 0 ]
[ shy 1 0 ]
[ 0 0
	* 1]
</pre>
	*
	* @param shx 		 the multiplier by which coordinates are shifted in the direction of the positive X axis as a factor of their Y coordinate
	* @param shy 		 the multiplier by which coordinates are shifted in the direction of the positive Y axis as a factor of their X coordinate
	* @return		an <code>AffineTransform</code> object that shears coordinates by the specified multipliers.
	**/
	 public  static com.ulcjava.base.application.util.AffineTransform getShearInstance(double shx, double shy)
	{
		return null;
	}


	/**
	* Retrieves the flag bits describing the conversion properties of this
	* transform.The return value is either one of the constants
TYPE_IDENTITY or
	* TYPE_GENERAL_TRANSFORM, or a combination of the appriopriate flag bits. A
	* valid combination of flag bits is an
exclusive OR operation that can combine
	* the TYPE_TRANSLATION flag bit in addition to either of the TYPE_UNIFORM_SCALE
	* or
TYPE_GENERAL_SCALE flag bits as well as either of the
	* TYPE_QUADRANT_ROTATION or TYPE_GENERAL_ROTATION flag bits.
	*
	* @return		the OR combination of any of the indicated flags that apply to this transform
	**/
	 public int getType()
	{
		return 0;
	}


	/**
	* Returns the determinant of the matrix representation of the transform. The
	* determinant is useful both to determine if the transform
can be inverted and
	* to get a single value representing the combined X and Y scaling of the
	* transform.
<p>
</p>
If the determinant is non-zero, then this transform is
	* invertible and the various methods that depend on the inverse transform do
	* notneed to throw an Exception If the determinant is zero then this transform
	* can not be inverted since the transform maps all input
coordinates onto a
	* lineor a point. If the determinant is near enough to zero then inverse
	* transform operations might not carry
enough precision to produce meaningful
	* results.
<p>
</p>
If this transform represents a uniform scale, as indicated
	* by the <code>getType</code> method then the determinant also represents
the
	* square of the uniform scale factor by which all of the points are expanded
	* from or contracted towards the origin. If this
transform represents a
	* non-uniform scale or more general transform then the determinant is not
	* likelyto represent a value useful for
any purpose other than determining if
	* inverse transforms are possible.
<p>
</p>
Mathematically, the determinant is
	* calculated using the formula:

<pre>
| m00 m01 m02 |
| m10 m11 m12 | = m00 *
	* m11 - m01 * m10
| 0 0 1 |
</pre>
	*
	* @return		the determinant of the matrix used to transform the coordinates.
	**/
	 public double getDeterminant()
	{
		return 0.0d;
	}


	/**
	* Retrieves the 6 specifiable values in the 3x3 affine transformation matrix and
	* places them into an array of double precisions values.
The values are stored
	* in the array as
	* {&nbsp;m00&nbsp;m10&nbsp;m01&nbsp;m11&nbsp;m02&nbsp;m12&nbsp;}. An array of 4
	* doubles can also
be specified, in which case only the first four elements
	* representing the non-transform parts of the array are retrieved and
	* the
valuesare stored into the array as
	* {&nbsp;m00&nbsp;m10&nbsp;m01&nbsp;m11&nbsp;}
	*
	* @param flatmatrix 		 the double array used to store the returned values.
	**/
	 public void getMatrix(double[] flatmatrix)
	{
	}


	/**
	* Returns the X coordinate scaling element (m00) of the 3x3 affine
	* transformationmatrix.
	*
	* @return		a double value that is the X coordinate of the scaling element of the affine transformation matrix.
	**/
	 public double getScaleX()
	{
		return 0.0d;
	}


	/**
	* Returns the Y coordinate scaling element (m11) of the 3x3 affine
	* transformationmatrix.
	*
	* @return		a double value that is the Y coordinate of the scaling element of the affine transformation matrix.
	**/
	 public double getScaleY()
	{
		return 0.0d;
	}


	/**
	* Returns the X coordinate shearing element (m01) of the 3x3 affine
	* transformation matrix.
	*
	* @return		a double value that is the X coordinate of the shearing element of the affine transformation matrix.
	**/
	 public double getShearX()
	{
		return 0.0d;
	}


	/**
	* Returns the Y coordinate shearing element (m10) of the 3x3 affine
	* transformation matrix.
	*
	* @return		a double value that is the Y coordinate of the shearing element of the affine transformation matrix.
	**/
	 public double getShearY()
	{
		return 0.0d;
	}


	/**
	* Returns the X coordinate of the translation element (m02) of the 3x3 affine
	* transformation matrix.
	*
	* @return		a double value that is the X coordinate of the translation element of the affine transformation matrix.
	**/
	 public double getTranslateX()
	{
		return 0.0d;
	}


	/**
	* Returns the Y coordinate of the translation element (m12) of the 3x3 affine
	* transformation matrix.
	*
	* @return		a double value that is the Y coordinate of the translation element of the affine transformation matrix.
	**/
	 public double getTranslateY()
	{
		return 0.0d;
	}


	/**
	* Concatenates this transform with a translation transformation. This is
	* equivalent to calling concatenate(T), where T is
	* an
<code>AffineTransform</code> represented by the following matrix:

<pre>
[
	* 1 0 tx ]
[ 0 1 ty ]
[ 0 0 1 ]
</pre>
	*
	* @param tx 		 the distance by which coordinates are translated in the X axis direction
	* @param ty 		 the distance by which coordinates are translated in the Y axis direction
	**/
	 public void translate(double tx, double ty)
	{
	}


	/**
	* Concatenates this transform with a rotation transformation. This is equivalent
	* to calling concatenate(R), where R is an
<code>AffineTransform</code>
	* represented by the following matrix:

<pre>
[ cos(theta) -sin(theta) 0 ]
[
	* sin(theta) cos(theta) 0 ]
[ 0 0 1 ]
</pre>

Rotating with a positive angle
	* theta rotates points on the positive x axis toward the positive y axis.
	*
	* @param theta 		 the angle of rotation in radians
	**/
	 public void rotate(double theta)
	{
	}


	/**
	* Concatenates this transform with a transform that rotates coordinates around
	* ananchor point. This operation is equivalent to
translating the coordinates
	* sothat the anchor point is at the origin (S1), then rotating them about the
	* new origin (S2), and finally
translating so that the intermediate origin is
	* restored to the coordinates of the original anchor point (S3).
<p>
</p>
This
	* operation is equivalent to the following sequence of
	* calls:

<pre>
translate(x, y); // S3: final translation
rotate(theta); // S2:
	* rotate around anchor
translate(-x, -y); // S1: translate anchor to
	* origin
</pre>

Rotating with a positive angle theta rotates points on the
	* positive x axis toward the positive y axis.
	*
	* @param theta 		 the angle of rotation in radians
	* @param x 		 the coordinates of the anchor point of the rotation
	* @param y 		 the coordinates of the anchor point of the rotation
	**/
	 public void rotate(double theta, double x, double y)
	{
	}


	/**
	* Concatenates this transform with a scaling transformation. This is equivalent
	* to calling concatenate(S), where S is an
<code>AffineTransform</code>
	* represented by the following matrix:

<pre>
[ sx 0 0 ]
[ 0 sy 0 ]
[ 0 0 1
	* ]
</pre>
	*
	* @param sx 		 the factor by which coordinates are scaled along the X axis direction
	* @param sy 		 the factor by which coordinates are scaled along the Y axis direction
	**/
	 public void scale(double sx, double sy)
	{
	}


	/**
	* Concatenates this transform with a shearing transformation. This is equivalent
	* to calling concatenate(SH), where SH is an
<code>AffineTransform</code>
	* represented by the following matrix:

<pre>
[ 1 shx 0 ]
[ shy 1 0 ]
[ 0 0 1
	* ]
</pre>
	*
	* @param shx 		 the multiplier by which coordinates are shifted in the direction of the positive X axis as a factor of their Y coordinate
	* @param shy 		 the multiplier by which coordinates are shifted in the direction of the positive Y axis as a factor of their X coordinate
	**/
	 public void shear(double shx, double shy)
	{
	}


	/**
	* Resets this transform to the Identity transform.
	*
	**/
	 public void setToIdentity()
	{
	}


	/**
	* Sets this transform to a translation transformation. The matrix representing
	* this transform becomes:

<pre>
[ 1 0 tx ]
[ 0 1 ty ]
[ 0 0 1 ]
</pre>
	*
	* @param tx 		 the distance by which coordinates are translated in the X axis direction
	* @param ty 		 the distance by which coordinates are translated in the Y axis direction
	**/
	 public void setToTranslation(double tx, double ty)
	{
	}


	/**
	* Sets this transform to a rotation transformation. The matrix representing this
	* transform becomes:

<pre>
[ cos(theta) -sin(theta) 0 ]
[ sin(theta)
	* cos(theta)0 ]
[ 0 0 1 ]
</pre>

Rotating with a positive angle theta rotates
	* points on the positive x axis toward the positive y axis.
	*
	* @param theta 		 the angle of rotation in radians
	**/
	 public void setToRotation(double theta)
	{
	}


	/**
	* Sets this transform to a translated rotation transformation. This operation is
	* equivalent to translating the coordinates so that the
anchor point is at the
	* origin (S1), then rotating them about the new origin (S2), and finally
	* translating so that the intermediate
origin is restored to the coordinates of
	* the original anchor point (S3).
<p>
</p>
This operation is equivalent to the
	* following sequence of calls:

<pre>
setToTranslation(x, y); // S3: final
	* translation
rotate(theta); // S2: rotate around anchor
translate(-x, -y); //
	* S1: translate anchor to origin
</pre>

The matrix representing this transform
	* becomes:

<pre>
[ cos(theta) -sin(theta) x-x*cos+y*sin ]
[ sin(theta)
	* cos(theta) y-x*sin-y*cos ]
[ 0 0 1 ]
</pre>

Rotating with a positive angle
	* theta rotates points on the positive x axis toward the positive y axis.
	*
	* @param theta 		 the angle of rotation in radians
	* @param x 		 the coordinates of the anchor point of the rotation
	* @param y 		 the coordinates of the anchor point of the rotation
	**/
	 public void setToRotation(double theta, double x, double y)
	{
	}


	/**
	* Sets this transform to a scaling transformation. The matrix representing this
	* transform becomes:

<pre>
[ sx 0 0 ]
[ 0 sy 0 ]
[ 0 0 1 ]
</pre>
	*
	* @param sx 		 the factor by which coordinates are scaled along the X axis direction
	* @param sy 		 the factor by which coordinates are scaled along the Y axis direction
	**/
	 public void setToScale(double sx, double sy)
	{
	}


	/**
	* Sets this transform to a shearing transformation. The matrix representing this
	* transform becomes:

<pre>
[ 1 shx 0 ]
[ shy 1 0 ]
[ 0 0 1 ]
</pre>
	*
	* @param shx 		 the multiplier by which coordinates are shifted in the direction of the positive X axis as a factor of their Y coordinate
	* @param shy 		 the multiplier by which coordinates are shifted in the direction of the positive Y axis as a factor of their X coordinate
	**/
	 public void setToShear(double shx, double shy)
	{
	}


	/**
	* Sets this transform to a copy of the transform in the specified
	* <code>AffineTransform</code> object.
	*
	* @param Tx 		 the <code>AffineTransform</code> object from which to copy the transform
	**/
	 public void setTransform(com.ulcjava.base.application.util.AffineTransform Tx)
	{
	}


	/**
	* Sets this transform to the matrix specified by the 6 double precision values.
	*
	* @param m00 		 one of the 6 floating point values that compose the 3x3 transformation matrix
	* @param m01 		 one of the 6 floating point values that compose the 3x3 transformation matrix
	* @param m02 		 one of the 6 floating point values that compose the 3x3 transformation matrix
	* @param m10 		 one of the 6 floating point values that compose the 3x3 transformation matrix
	* @param m11 		 one of the 6 floating point values that compose the 3x3 transformation matrix
	* @param m12 		 one of the 6 floating point values that compose the 3x3 transformation matrix
	**/
	 public void setTransform(double m00, double m10, double m01, double m11, double m02, double m12)
	{
	}


	/**
	* Concatenates an <code>AffineTransform</code> <code>Tx</code> to this
	* <code>AffineTransform</code> Cx in the most commonly
useful way to provide a
	* new user space that is mapped to the former user space by <code>Tx</code>. Cx
	* is updated to perform the
combined transformation. Transforming a point p by
	* the updated transform Cx' is equivalent to first transforming p by
	* <code>Tx</code>
and then transforming the result by the original transform Cx
	* like this: Cx'(p) = Cx(Tx(p)) In matrix notation, if this transform Cx
is
	* represented by the matrix [this] and <code>Tx</code> is represented by the
	* matrix [Tx] then this method does the following:

<pre>
[this] = [this] x
	* [Tx]</pre>
	*
	* @param Tx 		 the <code>AffineTransform</code> object to be concatenated with this <code>AffineTransform</code> object.
	* @see		#preConcatenate
	**/
	 public void concatenate(com.ulcjava.base.application.util.AffineTransform Tx)
	{
	}


	/**
	* Concatenates an <code>AffineTransform</code> <code>Tx</code> to this
	* <code>AffineTransform</code> Cx in a less commonly used
way such that
	* <code>Tx</code> modifies the coordinate transformation relative to the
	* absolute pixel space rather than relative to
the existing user space. Cx is
	* updated to perform the combined transformation. Transforming a point p by the
	* updated transform Cx' is
equivalent to first transforming p by the original
	* transform Cx and then transforming the result by <code>Tx</code> like
	* this:
Cx'(p) = Tx(Cx(p)) In matrix notation, if this transform Cx is
	* represented by the matrix [this] and <code>Tx</code> is represented
by the
	* matrix [Tx] then this method does the following:

<pre>
[this] = [Tx] x
	* [this]</pre>
	*
	* @param Tx 		 the <code>AffineTransform</code> object to be concatenated with this <code>AffineTransform</code> object.
	* @see		#concatenate
	**/
	 public void preConcatenate(com.ulcjava.base.application.util.AffineTransform Tx)
	{
	}


	/**
	* Returns an <code>AffineTransform</code> object representing the inverse
	* transformation. The inverse transform Tx' of this transform
Tx maps
	* coordinates transformed by Tx back to their original coordinates. In other
	* words, Tx'(Tx(p)) = p = Tx(Tx'(p)).
<p>
</p>
If this transform maps all
	* coordinates onto a point or a line then it will not have an inverse, since
	* coordinates that do not lie on
the destination point or line will not have an
	* inverse mapping. The <code>getDeterminant</code> method can be used to
	* determine if
this transform has no inverse, in which case an exception will
	* bethrown if the <code>createInverse</code> method is called.
	*
	* @return		a new <code>AffineTransform</code> object representing the inverse transformation.
	* @throws		Exception if the matrix cannot be inverted.
	**/
	 public com.ulcjava.base.application.util.AffineTransform createInverse()throws java.lang.Exception
	{
		return null;
	}


	/**
	* Transforms an array of floating point coordinates by this transform. The two
	* coordinate array sections can be exactly the same or can
be overlapping
	* sections of the same array without affecting the validity of the results.
	* Thismethod ensures that no source
coordinates are overwritten by a previous
	* operation before they can be transformed. The coordinates are stored in the
	* arrays starting
at the specified offset in the order <code>[x0, y0, x1, y1,
	* ..., xn, yn]</code>.
	*
	* @param srcPts 		 the array containing the source point coordinates. Each point is stored as a pair of x,&nbsp;y coordinates.
	* @param dstPts 		 the array into which the transformed point coordinates are returned. Each point is stored as a pair of x,&nbsp;y
coordinates.
	* @param srcOff 		 the offset to the first point to be transformed in the source array
	* @param dstOff 		 the offset to the location of the first transformed point that is stored in the destination array
	* @param numPts 		 the number of points to be transformed
	**/
	 public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts)
	{
	}


	/**
	* Transforms an array of double precision coordinates by this transform. The two
	* coordinate array sections can be exactly the same or
can be overlapping
	* sections of the same array without affecting the validity of the results.
	* Thismethod ensures that no source
coordinates are overwritten by a previous
	* operation before they can be transformed. The coordinates are stored in the
	* arrays starting
at the indicated offset in the order <code>[x0, y0, x1, y1,
	* ..., xn, yn]</code>.
	*
	* @param srcPts 		 the array containing the source point coordinates. Each point is stored as a pair of x,&nbsp;y coordinates.
	* @param dstPts 		 the array into which the transformed point coordinates are returned. Each point is stored as a pair of x,&nbsp;y
coordinates.
	* @param srcOff 		 the offset to the first point to be transformed in the source array
	* @param dstOff 		 the offset to the location of the first transformed point that is stored in the destination array
	* @param numPts 		 the number of point objects to be transformed
	**/
	 public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts)
	{
	}


	/**
	* Transforms an array of floating point coordinates by this transform and stores
	* the results into an array of doubles. The coordinates
are stored in the
	* arraysstarting at the specified offset in the order <code>[x0, y0, x1, y1,
	* ..., xn, yn]</code>.
	*
	* @param srcPts 		 the array containing the source point coordinates. Each point is stored as a pair of x,&nbsp;y coordinates.
	* @param dstPts 		 the array into which the transformed point coordinates are returned. Each point is stored as a pair of x,&nbsp;y
coordinates.
	* @param srcOff 		 the offset to the first point to be transformed in the source array
	* @param dstOff 		 the offset to the location of the first transformed point that is stored in the destination array
	* @param numPts 		 the number of points to be transformed
	**/
	 public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts)
	{
	}


	/**
	* Transforms an array of double precision coordinates by this transform and
	* stores the results into an array of floats. The coordinates
are stored in the
	* arrays starting at the specified offset in the order <code>[x0, y0, x1, y1,
	* ..., xn, yn]</code>.
	*
	* @param srcPts 		 the array containing the source point coordinates. Each point is stored as a pair of x,&nbsp;y coordinates.
	* @param dstPts 		 the array into which the transformed point coordinates are returned. Each point is stored as a pair of x,&nbsp;y
coordinates.
	* @param srcOff 		 the offset to the first point to be transformed in the source array
	* @param dstOff 		 the offset to the location of the first transformed point that is stored in the destination array
	* @param numPts 		 the number of point objects to be transformed
	**/
	 public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts)
	{
	}


	/**
	* Inverse transforms an array of double precision coordinates by this transform.
	* The two coordinate array sections can be exactly the
same or can be
	* overlapping sections of the same array without affecting the validity of the
	* results. This method ensures that no
source coordinates are overwritten by a
	* previous operation before they can be transformed. The coordinates are stored
	* in the arrays
starting at the specified offset in the order <code>[x0, y0,
	* x1,y1, ..., xn, yn]</code>.
	*
	* @param srcPts 		 the array containing the source point coordinates. Each point is stored as a pair of x,&nbsp;y coordinates.
	* @param dstPts 		 the array into which the transformed point coordinates are returned. Each point is stored as a pair of x,&nbsp;y
coordinates.
	* @param srcOff 		 the offset to the first point to be transformed in the source array
	* @param dstOff 		 the offset to the location of the first transformed point that is stored in the destination array
	* @param numPts 		 the number of point objects to be transformed
	* @throws		Exception if the matrix cannot be inverted.
	**/
	 public void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts)throws java.lang.Exception
	{
	}


	/**
	* Transforms an array of relative distance vectors by this transform. A relative
	* distance vector is transformed without applying the
translation components of
	* the affine transformation matrix using the following equations:

<pre>
[ x' ]
	* [ m00 m01 (m02) ] [ x ] [ m00x + m01y ]
[ y' ] = [ m10 m11 (m12) ] [ y ] = [
	* m10x + m11y ]
[ (1) ] [ (0) (0) ( 1 ) ] [ (1) ] [ (1) ]
</pre>

The two
	* coordinate array sections can be exactly the same or can be overlapping
	* sections of the same array without affecting the
validity of the results.
	* Thismethod ensures that no source coordinates are overwritten by a previous
	* operation before they can be
transformed. The coordinates are stored in the
	* arrays starting at the indicated offset in the order
<code>[x0, y0, x1, y1,
	* ..., xn, yn]</code>.
	*
	* @param srcPts 		 the array containing the source distance vectors. Each vector is stored as a pair of relative x,&nbsp;y coordinates.
	* @param dstPts 		 the array into which the transformed distance vectors are returned. Each vector is stored as a pair of relative
x,&nbsp;y coordinates.
	* @param srcOff 		 the offset to the first vector to be transformed in the source array
	* @param dstOff 		 the offset to the location of the first transformed vector that is stored in the destination array
	* @param numPts 		 the number of vector coordinate pairs to be transformed
	**/
	 public void deltaTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts)
	{
	}


	/**
	* Returns a <code>String</code> that represents the value of this {@link Object}.
	*
	* @return		a <code>String</code> representing the value of this <code>Object</code>.
	**/
	 public java.lang.String toString()
	{
		return null;
	}


	/**
	* Returns <code>true</code> if this <code>AffineTransform</code> is an identity
	* transform.
	*
	* @return		<code>true</code> if this <code>AffineTransform</code> is an identity transform; <code>false</code> otherwise.
	**/
	 public boolean isIdentity()
	{
		return false;
	}


	/**
	* Returns the hashcode for this transform.
	*
	* @return		a hash code for this transform.
	**/
	 public int hashCode()
	{
		return 0;
	}


	/**
	* Returns <code>true</code> if this <code>AffineTransform</code> represents the
	* same affine coordinate transform as the specified
argument.
	*
	* @param obj 		 the <code>Object</code> to test for equality with this <code>AffineTransform</code>
	* @return		<code>true</code> if <code>obj</code> equals this <code>AffineTransform</code> object; <code>false</code> otherwise.
	**/
	 public boolean equals(java.lang.Object obj)
	{
		return false;
	}


}