package com.ulcjava.base.application.util;


	/**
	* <code>BorderedComponentUtilities</code> provides methods to replace the use of
	* the deprecated <code>ULCBorderPane</code>. It also
helps to set a specific
	* margin and alignment to a
	* component.
<p>
</p>
<b>Features</b>
<p>
</p>
<ul>
<li>This class helps
	* migrating from the deprecated method {@link
	* com.ulcjava.base.application.ULCRootPane#add(String, ULCComponent)}.
<li>This
	* class helps migrating from the deprecated method
{@link
	* com.ulcjava.base.application.ULCTabbedPane#addTab(String, String,
	* ULCComponent)}.
<li>This class helps migrating from the deprecated
	* method
{@link com.ulcjava.base.application.ULCCardPane#addCard(String,
	* String,ULCComponent)}.
</ul>
<b>Examples</b>
<p>
</p>
Using bordered
	* components instead of setting the alignment in
	* <code>ULCRootPane</code>:
<p>
</p>

<pre>
frame.add(BorderedComponentUtilities.
	* createBorderedComponent(box,
ULCBoxPane.BOX_RIGHT_TOP,
	* BorderFactory.createEmptyBorder(5, 5,
	* 5,
5)));
</pre>

replaces

<pre>
frame.add(ULCBoxPane.BOX_RIGHT_TOP,
	* box);
</pre>

Using borderd components to specify the alignment and to set a
	* margin around a component in a
	* <code>ULCTabbedPane</code>:

<pre>
tabbedPane.add(BorderedComponentUtilities.cr
	* eateBorderedComponent(
new ULCButton(&quot;tabbedPane&quot;),
	* ULCBoxPane.BOX_LEFT_BOTTOM,
BorderFactory.createEmptyBorder(10, 10, 10,
	* 10)));tabbedPane.setTitleAt(1,
	* &quot;new&quot;);
</pre>

replaces

<pre>
tabbedPane.addTab(ULCBoxPane.BOX_LEFT
	* _BOTTOM, &quot;old&quot;, new
	* ULCButton(
&quot;tabbedPane&quot;));
</pre>

Using borderd components to
	* specify the alignment and to set a margin around a component in a
	* <code>ULCCardPane</code>:

<pre>
cardPane.add(BorderedComponentUtilities.create
	* BorderedComponent(newButton,
ULCBoxPane.BOX_RIGHT_CENTER,
	* BorderFactory.createEmptyBorder(10,
10, 10, 10)),
	* &quot;new&quot;);
</pre>

isequal to

<pre>
cardPane.addCard(&quot;old&quot;,
	* ULCBoxPane.BOX_RIGHT_CENTER, oldButton);
</pre>
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.ULCBoxPane
	* @see		com.ulcjava.base.application.ULCCardPane
	* @see		com.ulcjava.base.application.ULCTabbedPane
	* @see		com.ulcjava.base.application.ULCRootPane
	**/
 public class BorderedComponentUtilities extends java.lang.Object
{

	 private BorderedComponentUtilities()
	{
		 super();
	}


	/**
	* Adds the component to a box pane which has a ULCCompoundBorder consisting of a
	* ULCTitledBorder and a ULCEmptyBorder.
	*
	* @param component 		 the component to be decorated
	* @param title 		 the title of the border
	* @return		the box pane containing the component and with a border.
	**/
	 public  static com.ulcjava.base.application.ULCComponent createBorderedComponent(com.ulcjava.base.application.ULCComponent component, java.lang.String title)
	{
		return null;
	}


	/**
	* Adds the component to a box pane which has a ULCCompoundBorder consisting of a
	* ULCTitledBorder and a ULCEmptyBorder.
	*
	* @param component 		 the component to be decorated
	* @param title 		 the title of the border
	* @param titleFont 		 the font of the title
	* @return		the box pane containing the component and with a border.
	**/
	 public  static com.ulcjava.base.application.ULCComponent createBorderedComponent(com.ulcjava.base.application.ULCComponent component, java.lang.String title, com.ulcjava.base.application.util.Font titleFont)
	{
		return null;
	}


	/**
	* Adds the component to a box pane which has a ULCCompoundBorder consisting of a
	* ULCTitledBorder and a ULCEmptyBorder.
	*
	* @param component 		 the component to be decorated
	* @param title 		 the title of the border
	* @param titleColor 		 the color of the title
	* @return		the box pane containing the component and with a border.
	**/
	 public  static com.ulcjava.base.application.ULCComponent createBorderedComponent(com.ulcjava.base.application.ULCComponent component, java.lang.String title, com.ulcjava.base.application.util.Color titleColor)
	{
		return null;
	}


	/**
	* Adds the component to a box pane which has a ULCCompoundBorder consisting of a
	* ULCTitledBorder and a ULCEmptyBorder.
	*
	* @param component 		 the component to be decorated
	* @param title 		 the title of the border
	* @param titleFont 		 the title font
	* @param titleColor 		 the title color
	* @return		the box pane containing the component and with a border.
	**/
	 public  static com.ulcjava.base.application.ULCComponent createBorderedComponent(com.ulcjava.base.application.ULCComponent component, java.lang.String title, com.ulcjava.base.application.util.Font titleFont, com.ulcjava.base.application.util.Color titleColor)
	{
		return null;
	}


	/**
	* Adds the component to a box pane which has a ULCCompoundBorder consisting of a
	* ULCTitledBorder and a ULCEmptyBorder.
	*
	* @param component 		 the component to be decorated
	* @param title 		 the title of the border
	* @param margin 		 the insets of the empty border
	* @return		the box pane containing the component and with a border.
	**/
	 public  static com.ulcjava.base.application.ULCComponent createBorderedComponent(com.ulcjava.base.application.ULCComponent component, java.lang.String title, int margin)
	{
		return null;
	}


	/**
	* Adds the component to a box pane with the specified alignment. The alignment
	* can be one of the following
	* values:
<ul>
<li>BOX_EXPAND_EXPAND
<li>BOX_EXPAND_TOP
<li>BOX_EXPAND_CENTER
<li
	* >BOX_EXPAND_BOTTOM
<li>BOX_LEFT_EXPAND
<li>BOX_LEFT_TOP
<li>BOX_LEFT_CENTER
<li>
	* BOX_LEFT_BOTTOM
<li>BOX_CENTER_EXPAND
<li>BOX_CENTER_TOP
<li>BOX_CENTER_CENTER
<
	* li>BOX_CENTER_BOTTOM
<li>BOX_RIGHT_EXPAND
<li>BOX_RIGHT_TOP
<li>BOX_RIGHT_CENTER
	* <li>BOX_RIGHT_BOTTOM
</ul>
It sets a ULCCompoundBorder on the box pane which
	* has a ULCTitledBorder as an outside border and a ULCEmptyBorder as an
	* inside
border.
	*
	* @param component 		 the component to be decorated
	* @param title 		 the title of the border
	* @param alignment 		 the alignment string
	* @return		the box pane containing the component and with a border.
	**/
	 public  static com.ulcjava.base.application.ULCComponent createBorderedComponent(com.ulcjava.base.application.ULCComponent component, java.lang.String title, java.lang.String alignment)
	{
		return null;
	}


	/**
	* Adds the component to a box pane which has a ULCCompoundBorder consisting of a
	* ULCTitledBorder and a ULCEmptyBorder.
	*
	* @param component 		 the component to be decorated
	* @param title 		 the title of the border
	* @param titleJustification 		 the justification of the title
	* @param titlePosition 		 the position of the title
	* @return		the box pane containing the component and with a border.
	**/
	 public  static com.ulcjava.base.application.ULCComponent createBorderedComponent(com.ulcjava.base.application.ULCComponent component, java.lang.String title, int titleJustification, int titlePosition)
	{
		return null;
	}


	/**
	* Adds the component to a box pane with the specified alignment. The alignment
	* can be one of the following
	* values:
<ul>
<li>BOX_EXPAND_EXPAND
<li>BOX_EXPAND_TOP
<li>BOX_EXPAND_CENTER
<li
	* >BOX_EXPAND_BOTTOM
<li>BOX_LEFT_EXPAND
<li>BOX_LEFT_TOP
<li>BOX_LEFT_CENTER
<li>
	* BOX_LEFT_BOTTOM
<li>BOX_CENTER_EXPAND
<li>BOX_CENTER_TOP
<li>BOX_CENTER_CENTER
<
	* li>BOX_CENTER_BOTTOM
<li>BOX_RIGHT_EXPAND
<li>BOX_RIGHT_TOP
<li>BOX_RIGHT_CENTER
	* <li>BOX_RIGHT_BOTTOM
</ul>
It sets a ULCCompoundBorder on the box pane which
	* has a ULCTitledBorder as an outside border and a ULCEmptyBorder as an
	* inside
border.
	*
	* @param component 		 the component to be decorated
	* @param title 		 the title of the border
	* @param alignment 		 the alignment string
	* @param margin 		 the insets of the empty border
	* @param titleFont 		 the title font
	* @param titleColor 		 the title color
	* @return		the box pane containing the component and with a border.
	**/
	 public  static com.ulcjava.base.application.ULCComponent createBorderedComponent(com.ulcjava.base.application.ULCComponent component, java.lang.String title, java.lang.String alignment, int margin, com.ulcjava.base.application.util.Font titleFont, com.ulcjava.base.application.util.Color titleColor)
	{
		return null;
	}


	/**
	* Adds the component to a box pane with the specified alignment. The alignment
	* can be one of the following
	* values:
<ul>
<li>BOX_EXPAND_EXPAND
<li>BOX_EXPAND_TOP
<li>BOX_EXPAND_CENTER
<li
	* >BOX_EXPAND_BOTTOM
<li>BOX_LEFT_EXPAND
<li>BOX_LEFT_TOP
<li>BOX_LEFT_CENTER
<li>
	* BOX_LEFT_BOTTOM
<li>BOX_CENTER_EXPAND
<li>BOX_CENTER_TOP
<li>BOX_CENTER_CENTER
<
	* li>BOX_CENTER_BOTTOM
<li>BOX_RIGHT_EXPAND
<li>BOX_RIGHT_TOP
<li>BOX_RIGHT_CENTER
	* <li>BOX_RIGHT_BOTTOM
</ul>
It sets a ULCCompoundBorder on the box pane which
	* has a ULCTitledBorder as an outside border and a ULCEmptyBorder as an
	* inside
border.
	*
	* @param component 		 the component to be decorated
	* @param title 		 the title of the border
	* @param alignment 		 the alignment string
	* @param margin 		 the insets of the empty border
	* @param titleFont 		 the title font
	* @param titleColor 		 the title color
	* @param titleJustification 		 the justification of the title
	* @param titlePosition 		 the position of the title
	* @return		the box pane containing the component and with a border.
	**/
	 public  static com.ulcjava.base.application.ULCComponent createBorderedComponent(com.ulcjava.base.application.ULCComponent component, java.lang.String title, java.lang.String alignment, int margin, com.ulcjava.base.application.util.Font titleFont, com.ulcjava.base.application.util.Color titleColor, int titleJustification, int titlePosition)
	{
		return null;
	}


	/**
	* Creates a box pane with the specified border. Adds the component to the box
	* pane with the specified alignment. To make sure the
alignment is shown, the
	* weights are set to 1.0.
<p>
The alignment can be one of the following
	* values:
<ul>
<li>BOX_EXPAND_EXPAND
<li>BOX_EXPAND_TOP
<li>BOX_EXPAND_CENTER
<li
	* >BOX_EXPAND_BOTTOM
<li>BOX_LEFT_EXPAND
<li>BOX_LEFT_TOP
<li>BOX_LEFT_CENTER
<li>
	* BOX_LEFT_BOTTOM
<li>BOX_CENTER_EXPAND
<li>BOX_CENTER_TOP
<li>BOX_CENTER_CENTER
<
	* li>BOX_CENTER_BOTTOM
<li>BOX_RIGHT_EXPAND
<li>BOX_RIGHT_TOP
<li>BOX_RIGHT_CENTER
	* <li>BOX_RIGHT_BOTTOM
</ul>
	*
	* @param component 		 the component to be added
	* @param alignment 		 the alignment string
	* @param border 		 the border to be set
	* @return		the box pane in which the component was added.
	**/
	 public  static com.ulcjava.base.application.ULCComponent createBorderedComponent(com.ulcjava.base.application.ULCComponent component, java.lang.String alignment, com.ulcjava.base.application.border.ULCAbstractBorder border)
	{
		return null;
	}


}