package com.ulcjava.base.application.util;


	/**
	* The <code>Color</code> class encapsulates the RGB
	* colors.
<p>
</p>
<b>Features</b>
<ul>
<li>The <code>Color</code> class
	* provides constants for the available colors to be used with
	* <code>ULCComponent</code> objects.
<li>Use the <code>Color</code> class to
	* define custom colors by specifying their red, green and blue
	* components.
<li>Provides for creation of brighter or darker version of a
	* <code>Color</code> instance.
</ul>
<b>Examples</b>
<p>
</p>
The following
	* codesnippet shows how to use system colors to set the background color of an
	* <code>ULCTextField</code> according to the
current desktop
	* color:

<pre>
ULCTextField field = new
	* ULCTextField(10);
field.setForeground(Color.gray);
Color myColor = new
	* Color(200, 200, 200); // light gray
Color brighter = myColor.brighter(); //
	* white
Color darker = myColor.darker(); // dark gray
</pre>
	*
	* @ulc.application		
	**/
 public class Color extends java.lang.Object implements java.io.Serializable
{

	/**
	* The color white.
	*
	**/
	 public  final  static com.ulcjava.base.application.util.Color white = null;

	/**
	* The color light gray.
	*
	**/
	 public  final  static com.ulcjava.base.application.util.Color lightGray = null;

	/**
	* The color gray.
	*
	**/
	 public  final  static com.ulcjava.base.application.util.Color gray = null;

	/**
	* The color dark gray.
	*
	**/
	 public  final  static com.ulcjava.base.application.util.Color darkGray = null;

	/**
	* The color black.
	*
	**/
	 public  final  static com.ulcjava.base.application.util.Color black = null;

	/**
	* The color red.
	*
	**/
	 public  final  static com.ulcjava.base.application.util.Color red = null;

	/**
	* The color pink.
	*
	**/
	 public  final  static com.ulcjava.base.application.util.Color pink = null;

	/**
	* The color orange.
	*
	**/
	 public  final  static com.ulcjava.base.application.util.Color orange = null;

	/**
	* The color yellow.
	*
	**/
	 public  final  static com.ulcjava.base.application.util.Color yellow = null;

	/**
	* The color green.
	*
	**/
	 public  final  static com.ulcjava.base.application.util.Color green = null;

	/**
	* The color magenta.
	*
	**/
	 public  final  static com.ulcjava.base.application.util.Color magenta = null;

	/**
	* The color cyan.
	*
	**/
	 public  final  static com.ulcjava.base.application.util.Color cyan = null;

	/**
	* The color blue.
	*
	**/
	 public  final  static com.ulcjava.base.application.util.Color blue = null;


	/**
	* Constructs o <code>Color</code> object from given RGB (red, green, blue)
	* values. Those values must be within the range 0-255. It is
not guaranteed
	* thatthe exact specified color will always be used. The device will try to
	* choose the one being the closest match if
it is not capable of displaying
	* TrueColor (full RGB spectrum) colors. The alpha value is defaulted to 255.
	*
	* @param r 		 the red value
	* @param g 		 the green value
	* @param b 		 the blue value
	* @see		#getRed
	* @see		#getGreen
	* @see		#getBlue
	**/
	 public Color(int r, int g, int b)
	{
		 super();
	}


	/**
	* Constructs o <code>Color</code> object from given RGB (red, green, blue)
	* values. Those values must be within the range 0-255. It is
not guaranteed
	* thatthe exact specified color will always be used. The device will try to
	* choose the one being the closest match if
it is not capable of displaying
	* TrueColor (full RGB spectrum) colors.
	*
	* @param r 		 the red value
	* @param g 		 the green value
	* @param b 		 the blue value
	* @param a 		 the alpha value
	* @see		#getRed
	* @see		#getGreen
	* @see		#getBlue
	* @see		#getAlpha
	**/
	 public Color(int r, int g, int b, int a)
	{
		 super();
	}


	/**
	* Returns the component red. It will be a value within the range 0-255.
	*
	* @return		the red component.
	**/
	 public int getRed()
	{
		return 0;
	}


	/**
	* Returns the component green. It will be a value within the range 0-255.
	*
	* @return		the green component.
	**/
	 public int getGreen()
	{
		return 0;
	}


	/**
	* Returns the component blue. It will be a value within the range 0-255.
	*
	* @return		the blue component.
	**/
	 public int getBlue()
	{
		return 0;
	}


	/**
	* Returns the component alpha. It will be a value within the range 0-255.
	*
	* @return		the alpha component.
	**/
	 public int getAlpha()
	{
		return 0;
	}

	 public boolean equals(java.lang.Object obj)
	{
		return false;
	}

	 public int hashCode()
	{
		return 0;
	}


	/**
	* Returns a string representation of this color.
	*
	* @return		a string representation of this color
	**/
	 public java.lang.String toString()
	{
		return null;
	}


	/**
	* Returns a new <code>Color</code> that is a brighter version of this
	* <code>Color</code>.
<p>
</p>
An arbitrary scale factor is applied to each of
	* the three RGB components of this <code>Color</code> to create a brighter
	* version of
this <code>Color</code>. Although <code>brighter</code> and
	* <code>darker</code> are inverse operations, the results of a
series of
	* invocations of these two methods might be inconsistent because of rounding
	* errors.
	*
	* @return		a new <code>Color</code> object that is a brighter version of this <code>Color</code>.
	* @see		Color#darker
	**/
	 public com.ulcjava.base.application.util.Color brighter()
	{
		return null;
	}


	/**
	* Returns a new <code>Color</code> that is a darker version of this
	* <code>Color</code>.
<p>
</p>
An arbitrary scale factor is applied to each of
	* the three RGB components of this <code>Color</code> to create a darker
	* versionof
this <code>Color</code>. Although <code>brighter</code> and
	* <code>darker</code> are inverse operations, the results of a
series of
	* invocations of these two methods might be inconsistent because of rounding
	* errors.
	*
	* @return		a new <code>Color</code> object that is a darker version of this <code>Color</code>.
	* @see		Color#brighter
	**/
	 public com.ulcjava.base.application.util.Color darker()
	{
		return null;
	}


}