package com.ulcjava.base.application.util;


	/**
	* The <code>Font</code> class is used to define fonts to be used for components.
	* For a <code>Font</code> definition, the font name,
font style and font size
	* have to be specified. Fonts may also be derived from other fonts by applying
	* an
{@link AffineTransform affine transformation} or a new size or
	* style.
<p>
</p>
<b>Features</b>
<ul>
<li>The font name can be a logical font
	* name (i.e., <code>Dialog</code>, <code>DialogInput</code>,
	* <code>Monospaced</code>,
<code>Serif</code>, <code>SansSerif</code>, or
	* <code>Symbol</code>) or a font face name. For the latter approach, a
	* developermust take into account that the availability of certain fonts
	* dependson the client. For this reason, the <code>ClientContext</code>
class
	* offers the possibility to retrieve the available font families.</li>
<li>The
	* font style is an integer bitmask that may be <code>Font.PLAIN</code>,
	* <code>Font.BOLD</code>, <code>Font.ITALIC</code>
or a bitwise union of the
	* latter two, for example <code>Font.BOLD|Font.ITALIC</code>.
<li>The font size
	* is specified in points, either as an integral or a floating-point
	* value.</li>
<li><code>Font</code> objects are intended to immutable (although
	* the implementation does not currently enforce this).
	* The
<code>deriveFont</code> family of methods can be used to obtain new
	* <code>Font</code> instances that differ in size, style or
transform from an
	* existing instance.</li>
</ul>
<b>Examples</b>
<p>
</p>
The following code
	* snippet looks for the available font families on the client and tries to
	* locate the preferred font in this list. If
successful, the preferred font is
	* used, otherwise a default font is used.
</p>

<pre>
String
	* preferredFontFamily= &quot;Garamond&quot;;
String fontFamily =
	* &quot;Serif&quot;;
String[] availableFontFamilies =
	* ClientContext
.getAvailableFontFamilyNames();
if
	* (containsFontFamily(preferredFontFamily, availableFontFamilies)) {
fontFamily
	* = preferredFontFamily;
}
Font font = new Font(fontFamily, Font.PLAIN,
	* 12);
ULCLabel fontLabel = new ULCLabel(&quot;Font
	* demo&quot;);
fontLabel.setFont(font);
</pre>
	*
	* @ulc.application		
	**/
 public class Font extends java.lang.Object implements java.io.Serializable
{

	/**
	* The constant for the plain style.
	*
	**/
	 public  final  static int PLAIN = 0;

	/**
	* The constant for the bold style. This can be combined with {@link #ITALIC} for
	* a bold italic style.
	*
	**/
	 public  final  static int BOLD = 0;

	/**
	* The constant for the italicized style. This can be combined with {@link #BOLD}
	* for a bold italic style.
	*
	**/
	 public  final  static int ITALIC = 0;


	/**
	* Constructs a new instance with the specified properties.
	*
	* @param name 		 the font name, which is either a logical name or a font face name. Valid logical font names are: <code>"Dialog"</code>,
<code>
"DialogInput"</code>, <code>"Monospaced"</code>, <code>
"Serif"</code>, <code>"SansSerif"</code> and
<code>"Symbol"</code>. The available font face names depend on the client (see
{@link com.ulcjava.base.application.ClientContext#getAvailableFontFamilyNames()}. If <code>name</code> is null, the
string <code>"Default"</code> is used instead.
	* @param style 		 the font style, either {@link Font#PLAIN} or a bitwise union of {@link Font#BOLD} and/or {@link Font#ITALIC}.
	* @param size 		 the size of the font in points (one point is roughly 1/72 inch)
	* @param transform 		 the affine transformation for this font, or null if none. A non-null value is copied by this constructor and no
reference to the original is retained.
	* @throws		IllegalArgumentException if <code>style</code> is not one of <code>PLAIN</code>, <code>BOLD</code>,
<code>ITALIC</code> or <code>BOLD|ITALIC</code> or if <code>size</code> is negative
	**/
	 public Font(java.lang.String name, int style, float size, com.ulcjava.base.application.util.AffineTransform transform)
	{
		 super();
	}


	/**
	* Constructs a new <code>Font</code> using the specified name, style and point
	* size. Calling this constructor is equivalent to
calling the {@link
	* #Font(String, int, float, AffineTransform)} constructor and passing a null
	* <code>AffineTransform</code>.
	*
	* @param name 		 the font name
	* @param style 		 the font style
	* @param size 		 the font size in points
	* @throws		IllegalArgumentException if <code>style</code> is not one of <code>PLAIN</code>, <code>BOLD</code>,
<code>ITALIC</code> or <code>BOLD|ITALIC</code> or if <code>size</code> is negative
	**/
	 public Font(java.lang.String name, int style, int size)
	{
		 super();
	}


	/**
	* Constructs a new <code>Font</code> using the specified name, style and
	* (possibly fractional) point size. Calling this constructor
is equivalent to
	* calling the {@link #Font(String, int, float, AffineTransform)} constructor
	* andpassing a null
<code>AffineTransform</code>.
	*
	* @param name 		 the font name
	* @param style 		 the font style
	* @param size 		 the font size in points
	* @throws		IllegalArgumentException if <code>style</code> is not one of <code>PLAIN</code>, <code>BOLD</code>,
<code>ITALIC</code> or <code>BOLD|ITALIC</code> or if <code>size</code> is negative
	**/
	 public Font(java.lang.String name, int style, float size)
	{
		 super();
	}


	/**
	* Returns the name of this <code>Font</code>, as passed to its constructor. If a
	* null name was passed, this methods returns the
string <code>
"Default"</code>.
	*
	* @return		the name of this font, never null
	**/
	 public java.lang.String getName()
	{
		return null;
	}


	/**
	* Returns the point size of this <code>Font</code>, rounded to the nearest
	* integer. Unless overridden, this method is equivalent to
the expression
	* <code>(int) (getSize2D() + 0.5)</code>.
	*
	* @return		the rounded point size of this <code>Font</code> (one point is roughly 1/72 inch)
	**/
	 public int getSize()
	{
		return 0;
	}


	/**
	* Returns the point size of this <code>Font</code>, as passed to its constructor.
	*
	* @return		the point size of this <code>Font</code> (one point is roughly 1/72 inch)
	**/
	 public float getSize2D()
	{
		return 0.0f;
	}


	/**
	* Returns the style of this <code>Font</code>, as passed to its constructor. The
	* style can be <code>PLAIN</code>,
<code>BOLD</code>, <code>ITALIC</code> or
	* <code>BOLD | ITALIC</code>.
	*
	* @return		the style of this <code>Font</code>
	**/
	 public int getStyle()
	{
		return 0;
	}


	/**
	* Indicates whether or not this <code>Font</code>'s style is <code>PLAIN</code>.
	*
	* @return		<code>true</code> if the style of this <code>Font</code> is equal to {@link Font#PLAIN}, <code>false</code> if not
	**/
	 public boolean isPlain()
	{
		return false;
	}


	/**
	* Indicates whether or not this <code>Font</code>'s style is a
	* <code>
BOLD</code>style.
	*
	* @return		<code>true</code> if the style has the {@link Font#BOLD} bit set, <code>false</code> if not
	**/
	 public boolean isBold()
	{
		return false;
	}


	/**
	* Indicates whether or not this <code>Font</code>'s style is an
	* <code>
ITALIC</code> style.
	*
	* @return		<code>true</code> if the style has the {@link Font#ITALIC} bit set, <code>false</code> if not
	**/
	 public boolean isItalic()
	{
		return false;
	}


	/**
	* Returns the <code>AffineTransform</code> object associated with this
	* <code>Font</code>, or null if there is none.
	*
	* @return		a reference to the internal <code>AffineTransform</code> object held by this font (which is a copy of the
<code>transform</code> argument passed to the constructor), or null if a null <code>transform</code> argument was passed
to the constructor. <em>Changes to the returned object are not supported and will
result in undefined behavior.</em>
	**/
	 public com.ulcjava.base.application.util.AffineTransform getAffineTransform()
	{
		return null;
	}


	/**
	* Creates a new <code>Font</code> object by replicating this <code>Font</code>
	* object and applying a new style to it.
	*
	* @param style 		 the style for the new <code>Font</code>. The new style completely replaces the style copied from this font object.
	* @return		a fresh copy of this <code>Font</code> object with style <code>style</code>
	**/
	 public com.ulcjava.base.application.util.Font deriveFont(int style)
	{
		return null;
	}


	/**
	* Creates a new <code>Font</code> object by replicating this <code>Font</code>
	* object and applying a new size to it.
	*
	* @param size 		 the size for the new <code>Font</code>
	* @return		a fresh copy of this <code>Font</code> object with size <code>size</code>
	**/
	 public com.ulcjava.base.application.util.Font deriveFont(float size)
	{
		return null;
	}


	/**
	* Creates a new <code>Font</code> object by replicating this <code>Font</code>
	* object and applying a new style and size to it.
	*
	* @param style 		 the style for the new <code>Font</code>. The new style completely replaces the style copied from this font object.
	* @param size 		 the size for the new <code>Font</code>
	* @return		a fresh copy of this <code>Font</code> object with style <code>style</code> and size <code>size</code>
	**/
	 public com.ulcjava.base.application.util.Font deriveFont(int style, float size)
	{
		return null;
	}


	/**
	* Creates a new <code>Font</code> object by replicating the current
	* <code>Font</code> object and applying a new affine
transformation to it.
	*
	* @param transform 		 the <code>AffineTransform</code> associated with the new <code>Font</code>. This transformation completely
replaces the transformation copied from this font object (if this object had a non-null transformation associated with
it). If null, the new font will not have an <code>AffineTransform</code> associated with it.
	* @return		a fresh copy of this <code>Font</code> object that uses transformation <code>transform</code>
	**/
	 public com.ulcjava.base.application.util.Font deriveFont(com.ulcjava.base.application.util.AffineTransform transform)
	{
		return null;
	}


	/**
	* Returns <code>true</code> iff the given object is a <code>Font</code> instance
	* whose <code>name</code>, <code>style</code>,
<code>size</code> and
	* <code>affineTransform</code> properties are equal to those of this font.
	*
	* @see		java.lang.Object#equals(java.lang.Object)
	**/
	 public boolean equals(java.lang.Object other)
	{
		return false;
	}


	/**
	* Returns a hash code compatible with {@link #equals(Object) equals}.
	*
	* @see		java.lang.Object#hashCode()
	**/
	 public int hashCode()
	{
		return 0;
	}


	/**
	* Returns an unspecified, but human-readable description of this
	* <code>Font</code> object.
	*
	* @return		a descripion of this object, never null
	**/
	 public java.lang.String toString()
	{
		return null;
	}


}