package com.ulcjava.base.application.util;


	/**
	* Choosing one or more files located on the client machine is a two-step
	* operation. First the static method
<code>ClientContext.chooseFile()</code>
	* hasto be called. This method has to be provided with an
	* <code>IFileChooseHandler</code>
argument. In a second step the ULC framework
	* invokes a hook in the provided <code>IFileChooseHandler</code> when the
	* selection has been
completed.
<p>
</p>
Not all client environments support
	* client-side file operations. For instance, applets running in the default
	* applet sandbox are not
allowed to read and write files.
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.ClientContext#chooseFile(IFileChooseHandler, com.ulcjava.base.shared.FileChooserConfig,
com.ulcjava.base.application.ULCComponent)
	**/
 public interface IFileChooseHandler
{

	/**
	* Indicates that the user cancelled the action.
	*
	**/
	 public  final  static int CANCELLED = 0;

	/**
	* Indicates that the action failed.
	*
	**/
	 public  final  static int FAILED = 0;


	/**
	* Invoked when the choose file action was successful.
	*
	* @param filePaths 		 the paths of the chosen files
	* @param fileNames 		 the names of the chosen files
	**/
	 public void onSuccess(java.lang.String[] filePaths, java.lang.String[] fileNames);

	/**
	* Invoked when the choose file action failed.
	*
	* @param reason 		 the reason of the failure, one of the following values:
<ul>
<li>CANCELLED: the user cancelled the action
<li>FAILED: the action failed
</ul>
	* @param description 		 the description of the failure
	**/
	 public void onFailure(int reason, java.lang.String description);

}