package com.ulcjava.base.application.util;


	/**
	* Reading one or more files located on the client machine is a two-step
	* operation. The first step is to initiate the client file download
by calling
	* the static <code>loadFile()</code> method in the <code>ClientContext</code>
	* class. This method has to be provided with an
<code>IFileLoadHandler</code>.
	* In a second step the ULC framework invokes a hook in the provided
	* <code>IFileLoadHandler</code> when
the download has been completed.
	*
	* @ulc.application		
	* @see		com.ulcjava.base.application.ClientContext#loadFile(IFileLoadHandler, com.ulcjava.base.shared.FileChooserConfig,
com.ulcjava.base.application.ULCComponent)
	* @see		com.ulcjava.base.application.ClientContext#loadFile(IFileLoadHandler, String)
	**/
 public interface IFileLoadHandler
{

	/**
	* Indicates that the user cancelled the action.
	*
	**/
	 public  final  static int CANCELLED = 0;

	/**
	* Indicates that the action failed.
	*
	**/
	 public  final  static int FAILED = 0;

	/**
	* Indicates that the maximum file size has been exceeded and the file load
	* operation has been aborted.
	*
	**/
	 public  final  static int FILE_SIZE_EXCEEDED = 0;


	/**
	* Invoked when the load file action was successful.
	*
	* @param ins 		 the input streams containing the loaded files
	* @param filePaths 		 the paths of the loaded files, or null when the client environment does not provide the file path information
	* @param fileNames 		 the names of the loaded files, or null when the client environment does not provide the file name information
	**/
	 public void onSuccess(java.io.InputStream[] ins, java.lang.String[] filePaths, java.lang.String[] fileNames);

	/**
	* Invoked when the load file action failed.
	*
	* @param reason 		 the reason of the failue, one of the following values:
<ul>
<li>CANCELLED: the user cancelled the action
<li>FAILED: the action failed
</ul>
	* @param description 		 the description of the failure
	**/
	 public void onFailure(int reason, java.lang.String description);

}