package com.ulcjava.base.client;


	/**
	* This interface defines if the component is used as a template or not.
	* Components used as renderer or editor components are stored as
templates. In
	* some cases it is necessary to override Swing behaviour of the basic widget to
	* take into account that the component is used
as a template, e.g. {@link
	* java.awt.Container#invalidate()}. All basic components of UI components which
	* are editor or renderer
components should implement this interface.
	*
	* @ulc.extension		
	* @see		UICheckBox.BasicCheckBox
	* @see		UIComboBox.BasicComboBox
	* @see		UILabel.BasicLabel
	* @see		UIPasswordField.BasicPasswordField
	* @see		UITextField.BasicTextField
	**/
 public interface IComponentTemplate
{


	/**
	* Defines if the component is a template or not.
	*
	* @param isTemplate 		 true if the component is a template, false otherwise.
	**/
	 public void setIsTemplate(boolean isTemplate);

	/**
	* Returns if the component is a template.
	*
	* @return		true if the component is a template, false otherwise.
	**/
	 public boolean isTemplate();

}