package com.ulcjava.base.client.launcher;


	/**
	* Handler that is called by the {@link DefaultSessionStateListener} on a session
	* error. The handler should present the error to the user
before the client is
	* terminated. <br>
Most conveniently the ISessionErrorHandler is configured in
	* the <i>ULCApplicationConfiguration.xml</i> file using
	* the
<code><ulc:clientErrorHandlerClassName></code> tag.
	*
	**/
 public interface ISessionErrorHandler
{


	/**
	* Present the error to the user.
	*
	* @param session 		 the {@link UISession} that is going to be terminated
	* @param reason 		 the Throwable that caused the termination.
	**/
	 public void handleSessionError(com.ulcjava.base.client.UISession session, java.lang.Throwable reason);

}