package com.ulcjava.base.server;


	/**
	* 
	*
	* @ulc.extension		
	**/
 public interface IContainerServices
{
	 public  final  static java.lang.String APPLICATION_CLASS_KEY = null;
	 public  final  static java.lang.String LOG_LEVEL_KEY = null;
	 public  final  static java.lang.String SERVER_CODER_REGISTRY_PROVIDER_KEY = null;
	 public  final  static java.lang.String DATA_STREAM_PROVIDER_KEY = null;
	 public  final  static java.lang.String CARRIER_STREAM_PROVIDER_KEY = null;
	 public  final  static java.lang.String MODEL_ADAPTER_PROVIDER_KEY = null;
	 public  final  static java.lang.String LOG_CONFIG_KEY = null;


	/**
	* Get the names of all initialization parameters that the container has been
	* started with. In case of a ULC servlet deployment, the
init parameters names
	* are taken from the <code>&lt;init-param&gt;</code> tag of the servlet's
	* configuration section in the
corresponding web XML file. In case of a ULC EJB
	* deployment, the init parameter names are taken from the JNDI name
	* context
<code>"java:comp/env"</code> (via {@link
	* javax.naming.InitialContext#list(String)}).
	*
	* @return		the init parameter names as an array
	**/
	 public java.lang.String[] getInitParameterNames();

	/**
	* Returns tha value associated with an init parameter.
	*
	* @param key 		 the name of the init parameter
	* @return		the value of the init parameter
	**/
	 public java.lang.String getInitParameter(java.lang.String key);

	/**
	* Returns the security principal associated with the container. In case of a ULC
	* servlet deployment, the principal of the current HTTP
request is returned. In
	* case of a ULC EJB deployment, the principal is taken from the session context
	* of the ULC container adapter
EJB.
	*
	* @return		the security principal associated with the container
	**/
	 public java.security.Principal getUserPrincipal();

	/**
	* Checks if the user associated with the current request is in an a given
	* security role. In case of a ULC servlet deployment, this
method delegates to
	* {@link javax.servlet.http.HttpServletRequest#isUserInRole(String)} of the
	* current HTTP request is returned. In
case of a ULC EJB deployment, this
	* methoddelegates to {@link javax.ejb.SessionContext#isCallerInRole(String)}
	* with respect to the
ULC container adapter EJB.
	*
	* @param role 		 the name of the security role
	* @return		<code>true</code> if the user in the given role, <code>false</code> otherwise
	**/
	 public boolean isUserInRole(java.lang.String role);

	/**
	* Gets an attribute value.
	*
	* @param key 		 the attribute key
	* @return		the attribute value or null if no value is bound to the key
	* @see		#setAttribute(String, Object)
	**/
	 public java.lang.Object getAttribute(java.lang.String key);

	/**
	* Sets an attribute value. The scope of the attribute value is the same as for
	* the container service itself. E.g., in case of a ULC
servlet deployment there
	* is on container service per ULC servlet and so, the attribute value is
	* accessable from all ULC sessions
associated with the same servlet.
	*
	* @param key 		 the attribute key
	* @param value 		 the attribute value
	**/
	 public void setAttribute(java.lang.String key, java.lang.Object value);

	/**
	* Removes an attribute value.
	*
	* @param key 		 the key of the attribute value to be removed
	* @see		#setAttribute(String, Object)
	**/
	 public void removeAttribute(java.lang.String key);

	/**
	* Returns the code denoting the server container type.
	*
	* @return		the code denoting the server container type
	* @see		com.ulcjava.base.application.ApplicationContext
	**/
	 public int getServerContainerType();

	/**
	* Returns the class name of the model adapter provider.
	*
	* @return		the class name of the model adapter provider
	**/
	 public java.lang.String getModelAdapterProviderClassName();

}