package com.ulcjava.base.server;


	/**
	* This class decorates the underlying <code>ITableModel</code> so that it can be
	* used with the <code>ULCTableModelAdapter</code> if
	* a
<code>TableRowSorter</code> is set on the <code>ULCTable</code>. When
	* required, it delegates method calls to the
	* referenced
<code>TableRowSorter</code> or the underlying
	* <code>ITableModel</code>.
	*
	* @ulc.internal		
	**/
 public class TableModelSortDecorator extends com.ulcjava.base.application.table.AbstractTableModel implements com.ulcjava.base.application.event.ITableModelListener, com.ulcjava.base.application.event.IRowSorterListener
{


	/**
	* Creates a <code>TableModelSortDecorator</code> instance.
	*
	* @param table 		 the table this sort decorator is responsible for
	**/
	 public TableModelSortDecorator(com.ulcjava.base.application.ULCTable table)
	{
		 super();
	}


	/**
	* Returns the number of columns in the table model.
	*
	* @return		the number of columns in the table model
	**/
	 public int getColumnCount()
	{
		return 0;
	}


	/**
	* Returns the number of rows that are shown by the <code>ULCTable</code>. The
	* view row count my differ from the model row count if
	* a
<code>TableRowFilter</code> is set to the <code>TableRowSorter</code>.
	*
	* @return		the number of rows in the view of the table
	**/
	 public int getRowCount()
	{
		return 0;
	}


	/**
	* Returns the cell value at specified row and column.
	*
	* @param row 		 the row of the cell
	* @param column 		 the column of the cell
	* @return		Object the value at the specified cell
	**/
	 public java.lang.Object getValueAt(int row, int column)
	{
		return null;
	}


	/**
	* Returns the name of the column in the model at the specified position.
	*
	* @param column 		 the position of the column in the model
	* @return		column the name of the column at the specified position in the model (the first index 0)
	**/
	 public java.lang.String getColumnName(int column)
	{
		return null;
	}


	/**
	* Returns the type of the column in the model at the specified position.
	*
	* @param column 		 the position of the column in the model
	* @return		Class the type of the column at the specified position in the model
	**/
	 public java.lang.Class getColumnClass(int column)
	{
		return null;
	}


	/**
	* Returns true if the cell at the specified row and column is editable. If the
	* value is false then <code>setValueAt</code> method has
no effect.
	*
	* @param row 		 the row index of the cell
	* @param column 		 the column index of the cell
	* @return		true if the cell is editable, false otherwise
	**/
	 public boolean isCellEditable(int row, int column)
	{
		return false;
	}


	/**
	* Sets the value of the cell in the table model at the specified row and column.
	*
	* @param value 		 the new value
	* @param row 		 the row index of the cell to be changed
	* @param column 		 the column index of the cell to be changed
	**/
	 public void setValueAt(java.lang.Object value, int row, int column)
	{
	}

	 public void tableChanged(com.ulcjava.base.application.event.TableModelEvent event)
	{
	}

	 public void sorterChanged(com.ulcjava.base.application.event.RowSorterEvent event)
	{
	}


}