package com.ulcjava.base.server.streamcoder;


	/**
	* A factory class to create the provider of the server-side coder registry. The
	* respective coder registry is used by ULC in order to
communicate by means of
	* ULC streams. In order to allow developers to add new coders to a coder
	* registry, the provider, which returns a
ready-made coder registry, must be
	* extendable. E.g., in the case of the server-side coder registry used by ULC,
	* the class
{@link DefaultServerCoderRegistryProvider} should be extended for
	* this purpose. ULC uses this factory class to obtain the
	* (potentially
extended)server-side coder registry provider.
	*
	* @ulc.extension		
	* @see		DefaultServerCoderRegistryProvider
	* @see		com.ulcjava.base.shared.ICoderRegistryProvider
	**/
 public class ServerCoderRegistryProviderFactory extends java.lang.Object
{


	/**
	* Creates a coder registry provider from a given class name. If the class name
	* is<code>null</code>, then an instance of
{@link
	* DefaultServerCoderRegistryProvider} is returned. If instantiation fails, then
	* an {@link IllegalArgumentException} is thrown.
	*
	* @param registryProviderClassName 		 the class name of the coder registry provider
	* @return		the created coder registry provider instance
	**/
	 public  static com.ulcjava.base.shared.ICoderRegistryProvider createCoderRegistryProvider(java.lang.String registryProviderClassName)
	{
		return null;
	}


}