package com.ulcjava.base.shared;


	/**
	* Constants that define the client environment type: APPLET, JNLP, STANDALONE,
	* DEVELOPMENT
	*
	**/
 public class ClientEnvironmentConstants extends java.lang.Object
{

	/**
	* The code that denotes that the client environment is not set properly and
	* therefore undefined
	*
	* @see		com.ulcjava.base.application.ClientContext#getClientEnvironmentType()
	**/
	 public  final  static int UNDEFINED = 0;

	/**
	* The code that denotes the application is launched with an appletLauncher
	*
	* @see		com.ulcjava.base.application.ClientContext#getClientEnvironmentType()
	**/
	 public  final  static int APPLET = 0;

	/**
	* The code that denotes the application is launched with a jnlpLauncher
	*
	* @see		com.ulcjava.base.application.ClientContext#getClientEnvironmentType()
	**/
	 public  final  static int JNLP = 0;

	/**
	* The code that denotes the application is launched with an standaloneLauncher
	*
	* @see		com.ulcjava.base.application.ClientContext#getClientEnvironmentType()
	**/
	 public  final  static int STANDALONE = 0;

	/**
	* The code that denotes the application is running with the development runner
	*
	* @see		com.ulcjava.base.application.ClientContext#getClientEnvironmentType()
	**/
	 public  final  static int DEVELOPMENT = 0;

	/**
	* The code that denotes the application is running with the local launcher
	*
	* @see		com.ulcjava.base.application.ClientContext#getClientEnvironmentType()
	**/
	 public  final  static int LOCAL = 0;

	 private ClientEnvironmentConstants()
	{
		 super();
	}


}