package com.ulcjava.base.shared;


	/**
	* This registry associates classes whose instances should be marshalled between
	* client and server via coders. A coder is a strategy class
that implements the
	* way in which an instance of a registered class is serialized to a ULC output
	* stream and deserialized from a ULC input
stream, respectively.
	*
	* @ulc.extension		
	* @see		IObjectInputStream
	* @see		IObjectOutputStream
	* @see		IStreamCoder
	**/
 public  final class CoderRegistry extends java.lang.Object
{


	/**
	* Gets the coder registered for a given class name. If <code>className</code> is
	* <code>null</code>, then this method returns
<code>null</code>.
	*
	* @param className 		 the class name to get the coder for
	* @return		<code>null</code> or the coder found for <code>className</code>
	**/
	 public com.ulcjava.base.shared.IStreamCoder getCoder(java.lang.String className)
	{
		return null;
	}


	/**
	* Gets the coder registered for a given class. If <code>clazz</code> is
	* <code>null</code>, then this method returns
<code>null</code>.
	*
	* @param clazz 		 the class to get the coder for
	* @return		<code>null</code> or the coder found for <code>clazz</code>
	**/
	 public com.ulcjava.base.shared.IStreamCoder getCoder(java.lang.Class clazz)
	{
		return null;
	}


	/**
	* Registers a coder for the given class name. If a coder is already registered
	* for <code>className</code>, then the existing
registry entry is overwritten.
	* If <code>coder</code> is <code>null</code>, then the registry entry for
	* <code>className</code>
is removed.
	*
	* @param className 		 the class name, for which to register a coder
	* @param coder 		 the coder to be registered
	* @throws		NullPointerException if <code>clazz</code> is <code>null</code>
	**/
	 public void registerCoder(java.lang.String className, com.ulcjava.base.shared.IStreamCoder coder)
	{
	}


	/**
	* Registers a coder for the given class. If a coder is already registered for
	* <code>clazz</code>, then the existing registry entry
is overwritten. If
	* <code>coder</code> is <code>null</code>, then the registry entry for
	* <code>clazz</code> is removed.
	*
	* @param clazz 		 the class, for which to register a coder
	* @param coder 		 the coder to be registered
	* @throws		NullPointerException if <code>clazz</code> is <code>null</code>
	**/
	 public void registerCoder(java.lang.Class clazz, com.ulcjava.base.shared.IStreamCoder coder)
	{
	}


}