package com.ulcjava.base.shared;


	/**
	* In ULC, a carrier stream is the basic Java IO stream which is used to run the
	* higher level communication protocol for exchanging ULC
requests and
	* responses.This interface gives an extension programmer the opportunity to
	* exchange the carrier stream without affecting
ULC's higher level
	* communicationprotocol.
<p>
</p>
Implementations of this interface are used on
	* the client and the server side in order to encode/decode incoming and
	* outgoingstreams. For
the carrier stream mechanism to work in both
	* communication directions, implementations of {@link InputStream} and {@link
	* OutputStream}
are sufficient. However, it is crucial that the client and the
	* server both use the same type of carrier stream. E.g., if the client uses
a
	* zip-based carrier stream, then the server also must do this. Otherwise client
	* and server will fail to communicate.
<p>
</p>
Classes implementing this
	* interface must have a no-argument constructor. ULC uses the class {@link
	* CarrierStreamProviderFactory} in order
to obtain an implementation from a
	* given class name of this interface. (The "ULC Essentials Guide" describes how
	* ULC can be configured
such that this factory class provides the desired
	* carrier stream provider implementation.) ULC ships with three default
	* implementations
of this interface:
<ul>
<li>{@link
	* TrivialCarrierStreamProvider} provides a carrier stream without any further
	* encoding.
<li>{@link ZipCarrierStreamProvider} provides a carrier stream,
	* which performs a zip encoding.
<li>{@link TrivialCarrierStreamProvider}
	* provides a carrier stream, which performs a base 64 encoding.
</ul>
	*
	* @ulc.extension		
	**/
 public interface ICarrierStreamProvider
{


	/**
	* Gets a carrier output stream on the basis of a raw output stream. (The raw
	* output stream performs a trivial encoding of written
bytes.)
	*
	* @param basicOutputStream 		 the raw output stream provided by ULC
	* @return		the carrier output stream, which potentially performs a more complex encoding
	**/
	 public java.io.OutputStream getCarrierOutputStream(java.io.OutputStream basicOutputStream)throws java.io.IOException;

	/**
	* Gets a carrier input stream on the basis of a raw input stream. (The raw input
	* stream performs a trivial decoding when reading
bytes.)
	*
	* @param basicInputStream 		 the raw input stream provided by ULC
	* @return		the carrier input stream, which potentially performs a more complex decoding
	**/
	 public java.io.InputStream getCarrierInputStream(java.io.InputStream basicInputStream)throws java.io.IOException;

}