package com.ulcjava.base.shared;


	/**
	* Defines operations for writing primitive values and objects in a structured
	* format to some underlying output stream. This interface is
similar to {@link
	* java.io.ObjectOutput}, except that the byte-level representation of values
	* written via this interface is deliberately
left unspecified to allow for
	* future optimizations. The ULC communications layer decorates the raw
	* transportchannel between client and
server with an implementation of this
	* interface to relieve the marshalling code in ULC half objects from the burden
	* of encoding request
and state data at the byte level.
<p>
</p>
Data written
	* using this interface can only be read back via the {@link IObjectInputStream}
	* interface. For each data element written by a
<code>write</code><em>Type</em>
	* method, the reader must invoke the corresponding
	* <code>read</code><em>Type</em> method. There
is no automatic conversion of
	* types. The results of a <code>read</code><em>Type</em> invocation with a type
	* different from the
actual data type of the next data element in the stream
	* areundefined, as are the results of all subsequent read operations on
	* the
stream.
</p>
<p>
</p>
<strong>Instances of this interface are not
	* thread-safe.</strong> Clients must not share instance references among
	* threadsand should in
fact not retain references beyond the scope of the
	* methodto which the reference was passed. Instances may refer to thread-local
	* or
otherwise volatile state and will behave in an unspecified fashion if
	* accessed outside the method invocation to which the reference
	* was
provided.
</p>
<p>
</p>
	*
	* @ulc.extension		
	**/
 public interface IObjectOutputStream extends com.ulcjava.base.shared.IDataOutputStream
{


	/**
	* Writes an object to this stream. The object must be read back via {@link
	* IObjectInputStream#readObject()}.
	*
	* @param value 		 the object to write, may be null
	* @throws		IOException if the value could not be written properly.
	**/
	 public void writeObject(java.lang.Object value)throws java.io.IOException;

}